/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader.http_downlaoder;

import android.text.TextUtils;
import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import org.wlf.filedownloader.base.Download;
import org.wlf.filedownloader.base.FailException;
import org.wlf.filedownloader.helper.HttpConnectionHelper;
import org.wlf.filedownloader.http_downlaoder.ContentLengthInputStream;
import org.wlf.filedownloader.http_downlaoder.ContentRangeInfo;
import org.wlf.filedownloader.http_downlaoder.Range;

public class HttpDownloader
implements Download {
    private static final String TAG = HttpDownloader.class.getSimpleName();
    private static final int MAX_REDIRECT_COUNT = 5;
    private static final int CONNECT_TIMEOUT = 10000;
    private static final String CHARSET = "UTF-8";
    private String mUrl;
    private Range mRange;
    private String mAcceptRangeType;
    private String mETag;
    private int mConnectTimeout = 10000;
    private OnHttpDownloadListener mOnHttpDownloadListener;

    public HttpDownloader(String url) {
        this(url, null, null);
    }

    public HttpDownloader(String url, Range range, String acceptRangeType) {
        this(url, range, acceptRangeType, null);
    }

    public HttpDownloader(String url, Range range, String acceptRangeType, String eTag) {
        this.mUrl = url;
        this.mRange = range;
        this.mAcceptRangeType = acceptRangeType;
        this.mETag = eTag;
    }

    public void setOnHttpDownloadListener(OnHttpDownloadListener onHttpDownloadListener) {
        this.mOnHttpDownloadListener = onHttpDownloadListener;
    }

    @Override
    public void download() throws HttpDownloadException {
        block25: {
            String url = this.mUrl;
            HttpURLConnection conn = null;
            InputStream inputStream = null;
            try {
                int redirectCount;
                conn = HttpConnectionHelper.createDownloadFileConnection(url, this.mConnectTimeout, CHARSET, this.mRange);
                for (redirectCount = 0; conn != null && conn.getResponseCode() / 100 == 3 && redirectCount < 5; ++redirectCount) {
                    conn = HttpConnectionHelper.createDownloadFileConnection(conn.getHeaderField("Location"), this.mConnectTimeout, CHARSET, this.mRange);
                }
                Log.d((String)TAG, (String)("download 1\u3001\u51c6\u5907\u4e0b\u8f7d\uff0c\u91cd\u5b9a\u5411\uff1a" + redirectCount + "\u6b21" + "\uff0c\u6700\u5927\u91cd\u5b9a\u5411\u6b21\u6570\uff1a" + 5 + "\uff0curl\uff1a" + url));
                if (redirectCount > 5) {
                    throw new HttpDownloadException("over max redirect:5!", HttpDownloadException.TYPE_REDIRECT_COUNT_OVER_LIMITS);
                }
                int responseCode = conn.getResponseCode();
                if (responseCode == 200 || responseCode == 206) {
                    int contentLength = conn.getContentLength();
                    Log.d((String)TAG, (String)("download 2\u3001\u5f97\u5230\u670d\u52a1\u5668\u8fd4\u56de\u7684\u8d44\u6e90contentLength\uff1a" + contentLength + "\uff0c\u4f20\u5165\u7684range\uff1a" + this.mRange.toString() + "\uff0curl\uff1a" + url));
                    if (contentLength <= 0) {
                        throw new HttpDownloadException("content length illegal,get url file failed!", HttpDownloadException.TYPE_RESOURCES_SIZE_ILLEGAL);
                    }
                    if (!TextUtils.isEmpty((CharSequence)this.mETag)) {
                        String eTag = conn.getHeaderField("ETag");
                        Log.d((String)TAG, (String)("download 3\u3001\u5f97\u5230\u670d\u52a1\u5668\u8fd4\u56de\u7684\u8d44\u6e90eTag\uff1a" + eTag + "\uff0c\u4f20\u5165\u7684eTag\uff1a" + this.mETag + "\uff0curl\uff1a" + url));
                        if (TextUtils.isEmpty((CharSequence)eTag) || !this.mETag.equals(eTag)) {
                            throw new HttpDownloadException("eTag is not equal,please re-download!", HttpDownloadException.TYPE_ETAG_CHANGED);
                        }
                    }
                    if (!Range.isLegal(this.mRange) || this.mRange != null && this.mRange.getLength() > contentLength) {
                        this.mRange = new Range(0, contentLength);
                    } else if (this.mRange != null && !TextUtils.isEmpty((CharSequence)this.mAcceptRangeType)) {
                        Range serverResponseRange;
                        boolean isRangeValidateSucceed = false;
                        String contentRange = conn.getHeaderField("Content-Range");
                        ContentRangeInfo contentRangeInfo = ContentRangeInfo.getContentRangeInfo(contentRange);
                        if (contentRangeInfo != null && this.mRange.equals(serverResponseRange = new Range(contentRangeInfo.startPos, contentRangeInfo.endPos)) && this.mAcceptRangeType.equals(contentRangeInfo.contentType) && serverResponseRange.getLength() == contentLength) {
                            isRangeValidateSucceed = true;
                        }
                        if (!isRangeValidateSucceed) {
                            throw new HttpDownloadException("contentRange validate failed!", HttpDownloadException.TYPE_CONTENT_RANGE_VALIDATE_FAIL);
                        }
                    }
                    InputStream serverInputStream = conn.getInputStream();
                    inputStream = new ContentLengthInputStream(serverInputStream, contentLength);
                    Log.d((String)TAG, (String)("download 4\u3001\u51c6\u5907\u5904\u7406\u6570\u636e\uff0c\u83b7\u53d6\u670d\u52a1\u5668\u8fd4\u56de\u7684\u8d44\u6e90\u957f\u5ea6\u4e3a\uff1a" + contentLength + "\uff0c\u83b7\u53d6\u670d\u52a1\u5668\u8fd4\u56de\u7684\u8f93\u5165\u6d41\u957f\u5ea6\u4e3a\uff1a" + inputStream.available() + "\uff0c\u9700\u8981\u5904\u7406\u7684\u533a\u57df\u4e3a\uff1a" + this.mRange.toString() + "\uff0curl\uff1a" + url));
                    this.notifyDownloadConnected(inputStream, this.mRange.startPos);
                    break block25;
                }
                throw new HttpDownloadException("ResponseCode:" + responseCode + " error,can not read data!", HttpDownloadException.TYPE_RESPONSE_CODE_ERROR);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (e instanceof SocketTimeoutException || e.getCause() instanceof SocketTimeoutException) {
                    throw new HttpDownloadException("network timeout!", e, HttpDownloadException.TYPE_NETWORK_TIMEOUT);
                }
                if (e instanceof ConnectException || e instanceof UnknownHostException) {
                    throw new HttpDownloadException("network denied!", e, HttpDownloadException.TYPE_NETWORK_DENIED);
                }
                if (e instanceof HttpDownloadException) {
                    throw (HttpDownloadException)e;
                }
                throw new HttpDownloadException(e);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (conn != null) {
                    conn.disconnect();
                }
                Log.d((String)TAG, (String)("download 5\u3001\u4e0b\u8f7d\u5df2\u7ed3\u675f\uff0curl\uff1a" + url));
            }
        }
    }

    private void notifyDownloadConnected(InputStream inputStream, int startPosInTotal) {
        if (this.mOnHttpDownloadListener != null) {
            this.mOnHttpDownloadListener.onDownloadConnected(inputStream, startPosInTotal);
        }
    }

    public static interface OnHttpDownloadListener {
        public void onDownloadConnected(InputStream var1, int var2);
    }

    public static class HttpDownloadException
    extends FailException {
        private static final long serialVersionUID = -1264975040094495002L;
        public static final String TYPE_REDIRECT_COUNT_OVER_LIMITS = HttpDownloadException.class.getName() + "_TYPE_REDIRECT_COUNT_OVER_LIMITS";
        public static final String TYPE_RESOURCES_SIZE_ILLEGAL = HttpDownloadException.class.getName() + "_TYPE_RESOURCES_SIZE_ILLEGAL";
        public static final String TYPE_ETAG_CHANGED = HttpDownloadException.class.getName() + "_TYPE_ETAG_CHANGED";
        public static final String TYPE_CONTENT_RANGE_VALIDATE_FAIL = HttpDownloadException.class.getName() + "_TYPE_CONTENT_RANGE_VALIDATE_FAIL";
        public static final String TYPE_RESPONSE_CODE_ERROR = HttpDownloadException.class.getName() + "_TYPE_RESPONSE_CODE_ERROR";
        public static final String TYPE_NETWORK_TIMEOUT = HttpDownloadException.class.getName() + "_TYPE_NETWORK_TIMEOUT";
        public static final String TYPE_NETWORK_DENIED = HttpDownloadException.class.getName() + "_TYPE_NETWORK_DENIED";

        public HttpDownloadException(String detailMessage, String type) {
            super(detailMessage, type);
        }

        public HttpDownloadException(String detailMessage, Throwable throwable, String type) {
            super(detailMessage, throwable, type);
        }

        public HttpDownloadException(Throwable throwable) {
            super(throwable);
        }

        @Override
        protected void onInitTypeWithThrowable(Throwable throwable) {
            super.onInitTypeWithThrowable(throwable);
            if (this.isTypeInit() || throwable == null) {
                return;
            }
            if (throwable instanceof SocketTimeoutException) {
                this.setType(TYPE_NETWORK_TIMEOUT);
            }
        }
    }
}

