/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader.file_saver;

import android.os.SystemClock;
import android.util.Log;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import org.wlf.filedownloader.base.FailException;
import org.wlf.filedownloader.base.Save;
import org.wlf.filedownloader.base.Stoppable;
import org.wlf.filedownloader.file_saver.DownloadNoticeStrategy;
import org.wlf.filedownloader.util.FileUtil;

public class FileSaver
implements Save,
Stoppable {
    private static final String TAG = FileSaver.class.getSimpleName();
    private static final int BUFFER_SIZE_WRITE_TO_FILE = 32768;
    private String mUrl;
    private String mTempFilePath;
    private String mSaveFilePath;
    private int mFileTotalSize;
    private int mBufferSizeWriteToFile = 32768;
    private DownloadNoticeStrategy mDownloadNoticeStrategy = DownloadNoticeStrategy.NOTICE_AUTO;
    private boolean mIsStopped;
    private boolean mIsNotifyEnd;
    private OnFileSaveListener mOnFileSaveListener;

    public FileSaver(String url, String tempFilePath, String saveFilePath, int fileTotalSize) {
        this.mUrl = url;
        this.mTempFilePath = tempFilePath;
        this.mSaveFilePath = saveFilePath;
        this.mFileTotalSize = fileTotalSize;
        this.mIsStopped = false;
        this.mIsNotifyEnd = false;
    }

    public void setOnFileSaveListener(OnFileSaveListener onFileSaveListener) {
        this.mOnFileSaveListener = onFileSaveListener;
    }

    @Override
    public void saveData(InputStream inputStream, int startPosInTotal) throws FileSaveException {
        block27: {
            this.checkIsStop();
            FileUtil.createFileParentDir(this.mTempFilePath);
            FileUtil.createFileParentDir(this.mSaveFilePath);
            File tempFile = new File(this.mTempFilePath);
            File saveFile = new File(this.mSaveFilePath);
            String url = this.mUrl;
            byte[] buffer = new byte[this.mBufferSizeWriteToFile];
            int start = 0;
            int offset = 0;
            RandomAccessFile randomAccessFile = null;
            int cachedIncreaseSizeForNotify = 0;
            long lastNotifyTime = -1L;
            try {
                int handledSize = 0;
                int needHandleSize = inputStream.available();
                int increaseSize = 0;
                randomAccessFile = new RandomAccessFile(tempFile, "rwd");
                randomAccessFile.seek(startPosInTotal);
                if (this.mOnFileSaveListener != null) {
                    this.mOnFileSaveListener.onSaveDataStart();
                }
                Log.d((String)TAG, (String)("saveData 1\u3001\u51c6\u5907\u5199\u6587\u4ef6\u7f13\u5b58\uff0c\u8def\u5f84\uff1a" + tempFile.getAbsolutePath() + "\uff0curl\uff1a" + url));
                lastNotifyTime = SystemClock.elapsedRealtime();
                long curTime = SystemClock.elapsedRealtime();
                long percentSize = (long)((float)needHandleSize / 100.0f);
                while (!this.mIsStopped && (offset = inputStream.read(buffer, start, this.mBufferSizeWriteToFile)) != -1) {
                    randomAccessFile.write(buffer, start, offset);
                    increaseSize = offset - start;
                    handledSize += increaseSize;
                    cachedIncreaseSizeForNotify += increaseSize;
                    curTime = SystemClock.elapsedRealtime();
                    long dTime = curTime - lastNotifyTime;
                    switch (this.mDownloadNoticeStrategy) {
                        case NOTICE_AUTO: {
                            long maxNotifySize = percentSize * 50L;
                            if (dTime >= DownloadNoticeStrategy.NOTICE_BY_TIME.getValue()) {
                                Log.d((String)TAG, (String)("saveData 2\u3001\u6b63\u5728\u5199\u6587\u4ef6\u7f13\u5b58\uff0c\u5df2\u5904\u7406\uff1a" + handledSize + "\uff0c\u603b\u5171\u9700\u8981\u5904\u7406\uff1a" + needHandleSize + "\uff0c\u5b8c\u6210\uff08\u767e\u5206\u6bd4\uff09\uff1a" + (float)handledSize / (float)needHandleSize * 100.0f / 100.0f + "%" + "\uff0curl\uff1a" + url));
                                if (this.mOnFileSaveListener == null) break;
                                this.mOnFileSaveListener.onSavingData(cachedIncreaseSizeForNotify, needHandleSize);
                                cachedIncreaseSizeForNotify = 0;
                                lastNotifyTime = curTime;
                                break;
                            }
                            if ((long)cachedIncreaseSizeForNotify < maxNotifySize) break;
                            Log.d((String)TAG, (String)("saveData 2\u3001\u6b63\u5728\u5199\u6587\u4ef6\u7f13\u5b58\uff0c\u5df2\u5904\u7406\uff1a" + handledSize + "\uff0c\u603b\u5171\u9700\u8981\u5904\u7406\uff1a" + needHandleSize + "\uff0c\u5b8c\u6210\uff08\u767e\u5206\u6bd4\uff09\uff1a" + (float)handledSize / (float)needHandleSize * 100.0f / 100.0f + "%" + "\uff0curl\uff1a" + url));
                            if (this.mOnFileSaveListener == null) break;
                            this.mOnFileSaveListener.onSavingData(cachedIncreaseSizeForNotify, needHandleSize);
                            cachedIncreaseSizeForNotify = 0;
                            lastNotifyTime = curTime;
                            break;
                        }
                        case NOTICE_BY_SIZE: {
                            if ((long)cachedIncreaseSizeForNotify < this.mDownloadNoticeStrategy.getValue()) break;
                            Log.d((String)TAG, (String)("saveData 2\u3001\u6b63\u5728\u5199\u6587\u4ef6\u7f13\u5b58\uff0c\u5df2\u5904\u7406\uff1a" + handledSize + "\uff0c\u603b\u5171\u9700\u8981\u5904\u7406\uff1a" + needHandleSize + "\uff0c\u5b8c\u6210\uff08\u767e\u5206\u6bd4\uff09\uff1a" + (float)handledSize / (float)needHandleSize * 100.0f / 100.0f + "%" + "\uff0curl\uff1a" + url));
                            if (this.mOnFileSaveListener == null) break;
                            this.mOnFileSaveListener.onSavingData(cachedIncreaseSizeForNotify, needHandleSize);
                            cachedIncreaseSizeForNotify = 0;
                            lastNotifyTime = curTime;
                            break;
                        }
                        case NOTICE_BY_TIME: {
                            if (dTime < this.mDownloadNoticeStrategy.getValue()) break;
                            Log.d((String)TAG, (String)("saveData 2\u3001\u6b63\u5728\u5199\u6587\u4ef6\u7f13\u5b58\uff0c\u5df2\u5904\u7406\uff1a" + handledSize + "\uff0c\u603b\u5171\u9700\u8981\u5904\u7406\uff1a" + needHandleSize + "\uff0c\u5b8c\u6210\uff08\u767e\u5206\u6bd4\uff09\uff1a" + (float)handledSize / (float)needHandleSize * 100.0f / 100.0f + "%" + "\uff0curl\uff1a" + url));
                            if (this.mOnFileSaveListener == null) break;
                            this.mOnFileSaveListener.onSavingData(cachedIncreaseSizeForNotify, needHandleSize);
                            cachedIncreaseSizeForNotify = 0;
                            lastNotifyTime = curTime;
                        }
                    }
                }
                if (cachedIncreaseSizeForNotify > 0) {
                    Log.d((String)TAG, (String)("saveData 2\u3001\u6b63\u5728\u5199\u6587\u4ef6\u7f13\u5b58\uff0c\u5df2\u5904\u7406\uff1a" + handledSize + "\uff0c\u603b\u5171\u9700\u8981\u5904\u7406\uff1a" + needHandleSize + "\uff0c\u5b8c\u6210\uff08\u767e\u5206\u6bd4\uff09\uff1a" + (float)handledSize / (float)needHandleSize * 100.0f / 100.0f + "%" + "\uff0curl\uff1a" + url));
                    if (this.mOnFileSaveListener != null) {
                        this.mOnFileSaveListener.onSavingData(cachedIncreaseSizeForNotify, needHandleSize);
                        cachedIncreaseSizeForNotify = 0;
                        lastNotifyTime = curTime;
                    }
                }
                if (needHandleSize == handledSize && tempFile.length() == (long)this.mFileTotalSize) {
                    boolean isCompleted;
                    if (saveFile.exists()) {
                        saveFile.delete();
                    }
                    if (!(isCompleted = tempFile.renameTo(saveFile))) {
                        throw new FileSaveException("rename temp file:" + tempFile.getAbsolutePath() + " failed!", FileSaveException.TYPE_RENAME_TEMP_FILE_ERROR);
                    }
                    Log.d((String)TAG, (String)("saveData 3\u3001\u6587\u4ef6\u4fdd\u5b58\u5b8c\u6210\uff0c\u8def\u5f84\uff1a" + saveFile.getAbsolutePath() + "\uff0curl\uff1a" + url));
                    this.notifyEnd(cachedIncreaseSizeForNotify, isCompleted);
                    break block27;
                }
                if (this.mIsStopped) {
                    this.notifyEnd(cachedIncreaseSizeForNotify, false);
                    break block27;
                }
                throw new FileSaveException("saving data error!", FileSaveException.TYPE_UNKNOWN);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (e instanceof FileSaveException) {
                    throw (FileSaveException)e;
                }
                throw new FileSaveException(e);
            }
            finally {
                if (randomAccessFile != null) {
                    try {
                        randomAccessFile.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (this.mIsNotifyEnd) {
                    cachedIncreaseSizeForNotify = 0;
                }
                if (!this.mIsNotifyEnd) {
                    this.notifyEnd(cachedIncreaseSizeForNotify, false);
                }
                this.mIsStopped = true;
            }
        }
    }

    private void notifyEnd(int increaseSize, boolean complete) {
        if (this.mIsNotifyEnd) {
            return;
        }
        if (this.mOnFileSaveListener != null) {
            this.mOnFileSaveListener.onSaveDataEnd(increaseSize, complete);
            this.mIsNotifyEnd = true;
        }
        if (this.mIsNotifyEnd && !this.isStopped()) {
            this.stop();
        }
    }

    private void checkIsStop() throws FileSaveException {
        if (this.isStopped()) {
            Log.d((String)TAG, (String)"checkIsStop --\u5df2\u7ecf\u5904\u7406\u5b8c\u4e86/\u5f3a\u5236\u505c\u6b62\u4e86\uff0c\u4e0d\u80fd\u518d\u5904\u7406\u6570\u636e\uff01");
            throw new FileSaveException("the file saver is stopped,can not handle data any more!", FileSaveException.TYPE_SAVER_IS_STOPPED);
        }
    }

    @Override
    public void stop() {
        this.mIsStopped = true;
    }

    @Override
    public boolean isStopped() {
        return this.mIsStopped;
    }

    public static interface OnFileSaveListener {
        public void onSaveDataStart();

        public void onSavingData(int var1, int var2);

        public void onSaveDataEnd(int var1, boolean var2);
    }

    public static class FileSaveException
    extends FailException {
        private static final long serialVersionUID = -4239369213699703830L;
        public static final String TYPE_RENAME_TEMP_FILE_ERROR = FileSaveException.class.getName() + "_TYPE_RENAME_TEMP_FILE_ERROR";
        public static final String TYPE_SAVER_IS_STOPPED = FileSaveException.class.getName() + "_TYPE_SAVER_IS_STOPPED";

        public FileSaveException(String detailMessage, String type) {
            super(detailMessage, type);
        }

        public FileSaveException(Throwable throwable) {
            super(throwable);
        }

        @Override
        protected void onInitTypeWithThrowable(Throwable throwable) {
            super.onInitTypeWithThrowable(throwable);
        }
    }
}

