/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader;

import android.util.Log;
import java.io.File;
import org.wlf.filedownloader.DownloadFileCacher;
import org.wlf.filedownloader.DownloadFileInfo;
import org.wlf.filedownloader.listener.OnDeleteDownloadFileListener;

public class DeleteDownloadFileTask
implements Runnable {
    private static final String TAG = DeleteDownloadFileTask.class.getSimpleName();
    private String mUrl;
    private boolean mDeleteDownloadedFileInPath;
    private DownloadFileCacher mFileDownloadCacher;
    private OnDeleteDownloadFileListener mOnDeleteDownloadFileListener;

    public DeleteDownloadFileTask(String url, boolean deleteDownloadedFileInPath, DownloadFileCacher fileDownloadCacher) {
        this.mUrl = url;
        this.mDeleteDownloadedFileInPath = deleteDownloadedFileInPath;
        this.mFileDownloadCacher = fileDownloadCacher;
    }

    public void setOnDeleteDownloadFileListener(OnDeleteDownloadFileListener onDeleteDownloadFileListener) {
        this.mOnDeleteDownloadFileListener = onDeleteDownloadFileListener;
    }

    @Override
    public void run() {
        DownloadFileInfo downloadFileInfo = this.mFileDownloadCacher.getDownloadFile(this.mUrl);
        OnDeleteDownloadFileListener.MainThreadHelper.onDeleteDownloadFilePrepared(downloadFileInfo, this.mOnDeleteDownloadFileListener);
        OnDeleteDownloadFileListener.OnDeleteDownloadFileFailReason failReason = null;
        if (downloadFileInfo != null) {
            boolean deleteResult = this.mFileDownloadCacher.deleteDownloadFile(downloadFileInfo);
            if (deleteResult) {
                Log.d((String)TAG, (String)("DeleteDownloadFileTask.run \u6570\u636e\u5e93\u5220\u9664\u6210\u529furl\uff1a" + this.mUrl));
                if (this.mDeleteDownloadedFileInPath) {
                    File file = new File(downloadFileInfo.getFileDir(), downloadFileInfo.getFileName());
                    if (file != null) {
                        if (file.exists()) {
                            deleteResult = file.delete();
                        } else {
                            file = new File(downloadFileInfo.getFileDir(), downloadFileInfo.getTempFileName());
                            if (file.exists()) {
                                deleteResult = file.delete();
                            }
                        }
                    } else {
                        file = new File(downloadFileInfo.getFileDir(), downloadFileInfo.getTempFileName());
                        if (file.exists()) {
                            deleteResult = file.delete();
                        }
                    }
                }
                if (deleteResult) {
                    Log.d((String)TAG, (String)("DeleteDownloadFileTask.run \u6570\u636e\u5e93+\u6587\u4ef6\u5220\u9664\u6210\u529furl\uff1a" + this.mUrl));
                    OnDeleteDownloadFileListener.MainThreadHelper.onDeleteDownloadFileSuccess(downloadFileInfo, this.mOnDeleteDownloadFileListener);
                    return;
                }
                failReason = new OnDeleteDownloadFileListener.OnDeleteDownloadFileFailReason("delete file in path failed!", OnDeleteDownloadFileListener.OnDeleteDownloadFileFailReason.TYPE_UNKNOWN);
            } else {
                failReason = new OnDeleteDownloadFileListener.OnDeleteDownloadFileFailReason("delete file in record failed!", OnDeleteDownloadFileListener.OnDeleteDownloadFileFailReason.TYPE_UNKNOWN);
            }
        } else {
            failReason = new OnDeleteDownloadFileListener.OnDeleteDownloadFileFailReason("file record is not exist!", OnDeleteDownloadFileListener.OnDeleteDownloadFileFailReason.TYPE_FILE_RECORD_IS_NOT_EXIST);
        }
        if (failReason != null) {
            Log.d((String)TAG, (String)("DeleteDownloadFileTask.run \u5220\u9664\u5931\u8d25url\uff1a" + this.mUrl + ",failReason:" + failReason.getType()));
            OnDeleteDownloadFileListener.MainThreadHelper.onDeleteDownloadFileFailed(downloadFileInfo, failReason, this.mOnDeleteDownloadFileListener);
        }
    }
}

