/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ListFunctions {
    public static <A, B extends A> Pair<List<A>, List<B>> splitByType(A[] items, Class<B> subType) {
        ArrayList<A> as = new ArrayList<A>();
        ArrayList<A> bs = new ArrayList<A>();
        for (A a : items) {
            if (subType.isAssignableFrom(a.getClass())) {
                bs.add(a);
                continue;
            }
            as.add(a);
        }
        return new Pair<List<A>, List<B>>(as, bs);
    }

    @SafeVarargs
    public static <T> List<T> concatenate(List<T> ... lists) {
        return Stream.of(lists).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private ListFunctions() {
        throw new UnsupportedOperationException("Not instantiable");
    }
}

