/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common.xml;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.ListOrSingle;
import com.github.tomakehurst.wiremock.common.xml.XmlDomNode;
import com.github.tomakehurst.wiremock.common.xml.XmlPrimitiveNode;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathEvaluationResult;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Node;

public abstract class XmlNode {
    protected static final ThreadLocal<XPath> XPATH_CACHE = ThreadLocal.withInitial(() -> {
        XPathFactory xPathfactory = XPathFactory.newDefaultInstance();
        return xPathfactory.newXPath();
    });
    protected static final ThreadLocal<Transformer> TRANSFORMER_CACHE = ThreadLocal.withInitial(() -> {
        TransformerFactory transformerFactory;
        try {
            transformerFactory = (TransformerFactory)Class.forName("com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            transformerFactory = TransformerFactory.newDefaultInstance();
        }
        transformerFactory.setAttribute("indent-number", 2);
        try {
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            return transformer;
        }
        catch (TransformerConfigurationException e) {
            return Exceptions.throwUnchecked(e, Transformer.class);
        }
    });

    public abstract Map<String, String> getAttributes();

    protected static ListOrSingle<XmlNode> toListOrSingle(XPathEvaluationResult<?> evaluationResult) {
        ListOrSingle<XmlNode> xmlNodes = new ListOrSingle<XmlNode>(new XmlNode[0]);
        switch (evaluationResult.type()) {
            case NODESET: {
                Iterable nodes = (Iterable)evaluationResult.value();
                nodes.forEach(node -> xmlNodes.add(new XmlDomNode((Node)node)));
                break;
            }
            case NODE: {
                xmlNodes.add(new XmlDomNode((Node)evaluationResult.value()));
                break;
            }
            default: {
                xmlNodes.add(new XmlPrimitiveNode(evaluationResult.value()));
            }
        }
        return xmlNodes;
    }
}

