/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common.url;

import com.github.tomakehurst.wiremock.common.url.PathParams;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Parser {
    private final Pattern templatePattern;
    private final List<String> templateParameters;

    Parser(Pattern templatePattern, List<String> templateParameters) {
        this.templatePattern = templatePattern;
        this.templateParameters = templateParameters;
    }

    boolean matches(String url) {
        Matcher matcher = this.templatePattern.matcher(url);
        return matcher.matches();
    }

    PathParams parse(String url) {
        Matcher matcher = this.templatePattern.matcher(url);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("'%s' is not a matching URL", url));
        }
        PathParams pathParams = new PathParams();
        for (int i = 0; i < this.templateParameters.size(); ++i) {
            pathParams.put(this.templateParameters.get(i), matcher.group(i + 1));
        }
        return pathParams;
    }

    int numberOfParameters() {
        return this.templateParameters.size();
    }
}

