/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.store.files;

import com.github.tomakehurst.wiremock.admin.NotFoundException;
import com.github.tomakehurst.wiremock.common.TextFile;
import com.github.tomakehurst.wiremock.store.BlobStore;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.wiremock.annotations.Beta;

@Beta(justification="Externalized State API: https://github.com/wiremock/wiremock/issues/2144")
public class BlobStoreTextFile
extends TextFile {
    private final BlobStore blobStore;
    private final String path;

    public BlobStoreTextFile(BlobStore blobStore, String path) {
        super(null);
        this.blobStore = blobStore;
        this.path = path;
    }

    @Override
    public byte[] readContents() {
        return (byte[])this.blobStore.get(this.path).orElseThrow(() -> new NotFoundException(this.path + " not found"));
    }

    @Override
    public String name() {
        return this.path;
    }

    @Override
    public String toString() {
        return this.name();
    }

    @Override
    public InputStream getStream() {
        return this.blobStore.getStream(this.path).orElseThrow(() -> new NotFoundException(this.path + " not found"));
    }

    @Override
    public String readContentsAsString() {
        return new String(this.readContents(), StandardCharsets.UTF_8);
    }

    @Override
    public String getPath() {
        return this.path;
    }
}

