/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsHelper;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.fasterxml.jackson.databind.node.ObjectNode;
import wiremock.com.github.jknack.handlebars.Options;
import wiremock.com.github.jknack.handlebars.TagType;

class JsonMergeHelper
extends HandlebarsHelper<Object> {
    JsonMergeHelper() {
    }

    public String apply(Object baseJsonString, Options options) throws IOException {
        JsonNode jsonToMerge;
        String jsonToMergeString;
        JsonNode baseJson;
        if (!(baseJsonString instanceof String)) {
            return this.handleError("Base JSON parameter must be a string");
        }
        try {
            baseJson = Json.read((String)baseJsonString, JsonNode.class);
        }
        catch (Exception e) {
            return this.handleError("Base JSON is not valid JSON ('" + baseJsonString + "')", e);
        }
        if (!(baseJson instanceof ObjectNode)) {
            return this.handleError("Base JSON is not a JSON object ('" + baseJsonString + "')");
        }
        if (options.tagType == TagType.SECTION) {
            jsonToMergeString = options.fn().toString();
        } else {
            String string = jsonToMergeString = options.params.length > 0 ? options.params[0] : null;
        }
        if (!(jsonToMergeString instanceof String)) {
            return this.handleError("JSON to merge must be a string");
        }
        try {
            jsonToMerge = Json.read(jsonToMergeString, JsonNode.class);
        }
        catch (Exception e) {
            return this.handleError("JSON to merge is not valid JSON ('" + jsonToMergeString + "')", e);
        }
        if (!(jsonToMerge instanceof ObjectNode)) {
            return this.handleError("JSON to merge is not a JSON object ('" + jsonToMergeString + "')");
        }
        boolean removeNulls = options.hash.containsKey("removeNulls") && (Boolean)options.hash.get("removeNulls") != false;
        this.merge((ObjectNode)baseJson, (ObjectNode)jsonToMerge, removeNulls);
        return Json.getObjectMapper().writeValueAsString(baseJson);
    }

    private void merge(ObjectNode base, ObjectNode other, boolean removeNulls) {
        Iterator<Map.Entry<String, JsonNode>> it = other.fields();
        while (it.hasNext()) {
            Map.Entry<String, JsonNode> child = it.next();
            String fieldName = child.getKey();
            JsonNode childNodeToMerge = child.getValue();
            if (childNodeToMerge instanceof ObjectNode) {
                JsonNode baseChildNode = base.get(fieldName);
                if (baseChildNode instanceof ObjectNode) {
                    this.merge((ObjectNode)baseChildNode, (ObjectNode)childNodeToMerge, removeNulls);
                    continue;
                }
                base.replace(fieldName, childNodeToMerge);
                continue;
            }
            if (removeNulls && childNodeToMerge.isNull()) {
                base.remove(fieldName);
                continue;
            }
            base.replace(fieldName, childNodeToMerge);
        }
    }
}

