/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.apache.hc.client5.http.impl.async;

import java.io.Closeable;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import wiremock.org.apache.hc.client5.http.HttpRoute;
import wiremock.org.apache.hc.client5.http.async.AsyncExecRuntime;
import wiremock.org.apache.hc.client5.http.auth.AuthSchemeFactory;
import wiremock.org.apache.hc.client5.http.auth.CredentialsProvider;
import wiremock.org.apache.hc.client5.http.config.RequestConfig;
import wiremock.org.apache.hc.client5.http.cookie.CookieSpecFactory;
import wiremock.org.apache.hc.client5.http.cookie.CookieStore;
import wiremock.org.apache.hc.client5.http.impl.async.AsyncExecChainElement;
import wiremock.org.apache.hc.client5.http.impl.async.AsyncPushConsumerRegistry;
import wiremock.org.apache.hc.client5.http.impl.async.InternalAbstractHttpAsyncClient;
import wiremock.org.apache.hc.client5.http.impl.async.InternalH2AsyncExecRuntime;
import wiremock.org.apache.hc.client5.http.impl.async.InternalH2ConnPool;
import wiremock.org.apache.hc.client5.http.protocol.HttpClientContext;
import wiremock.org.apache.hc.client5.http.routing.HttpRoutePlanner;
import wiremock.org.apache.hc.core5.annotation.Contract;
import wiremock.org.apache.hc.core5.annotation.Internal;
import wiremock.org.apache.hc.core5.annotation.ThreadingBehavior;
import wiremock.org.apache.hc.core5.http.HttpException;
import wiremock.org.apache.hc.core5.http.HttpHost;
import wiremock.org.apache.hc.core5.http.HttpRequest;
import wiremock.org.apache.hc.core5.http.config.Lookup;
import wiremock.org.apache.hc.core5.http.nio.AsyncPushConsumer;
import wiremock.org.apache.hc.core5.http.nio.HandlerFactory;
import wiremock.org.apache.hc.core5.reactor.DefaultConnectingIOReactor;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
@Internal
public final class InternalH2AsyncClient
extends InternalAbstractHttpAsyncClient {
    private static final Logger LOG = LoggerFactory.getLogger(InternalH2AsyncClient.class);
    private final HttpRoutePlanner routePlanner;
    private final InternalH2ConnPool connPool;

    InternalH2AsyncClient(DefaultConnectingIOReactor ioReactor, AsyncExecChainElement execChain, AsyncPushConsumerRegistry pushConsumerRegistry, ThreadFactory threadFactory, InternalH2ConnPool connPool, HttpRoutePlanner routePlanner, Lookup<CookieSpecFactory> cookieSpecRegistry, Lookup<AuthSchemeFactory> authSchemeRegistry, CookieStore cookieStore, CredentialsProvider credentialsProvider, RequestConfig defaultConfig, List<Closeable> closeables) {
        super(ioReactor, pushConsumerRegistry, threadFactory, execChain, cookieSpecRegistry, authSchemeRegistry, cookieStore, credentialsProvider, HttpClientContext::castOrCreate, defaultConfig, closeables);
        this.connPool = connPool;
        this.routePlanner = routePlanner;
    }

    @Override
    AsyncExecRuntime createAsyncExecRuntime(HandlerFactory<AsyncPushConsumer> pushHandlerFactory) {
        return new InternalH2AsyncExecRuntime(LOG, this.connPool, pushHandlerFactory);
    }

    @Override
    HttpRoute determineRoute(HttpHost httpHost, HttpRequest request, HttpClientContext clientContext) throws HttpException {
        HttpRoute route = this.routePlanner.determineRoute(httpHost, request, clientContext);
        if (route.isTunnelled()) {
            throw new HttpException("HTTP/2 tunneling not supported");
        }
        return route;
    }
}

