/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.networknt.schema.BaseJsonValidator;
import wiremock.com.networknt.schema.ExecutionContext;
import wiremock.com.networknt.schema.JsonNodePath;
import wiremock.com.networknt.schema.JsonSchema;
import wiremock.com.networknt.schema.SchemaLocation;
import wiremock.com.networknt.schema.ValidationContext;
import wiremock.com.networknt.schema.ValidationMessage;
import wiremock.com.networknt.schema.ValidatorTypeCode;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class IfValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(IfValidator.class);
    private static final List<String> KEYWORDS = Arrays.asList("if", "then", "else");
    private final JsonSchema ifSchema;
    private final JsonSchema thenSchema;
    private final JsonSchema elseSchema;

    public IfValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, ValidatorTypeCode.IF_THEN_ELSE, validationContext);
        JsonSchema foundIfSchema = null;
        JsonSchema foundThenSchema = null;
        JsonSchema foundElseSchema = null;
        for (String keyword : KEYWORDS) {
            JsonNode node = parentSchema.getSchemaNode().get(keyword);
            SchemaLocation schemaLocationOfSchema = parentSchema.schemaLocation.append(keyword);
            JsonNodePath evaluationPathOfSchema = parentSchema.evaluationPath.append(keyword);
            if (keyword.equals("if")) {
                foundIfSchema = validationContext.newSchema(schemaLocationOfSchema, evaluationPathOfSchema, node, parentSchema);
                continue;
            }
            if (keyword.equals("then") && node != null) {
                foundThenSchema = validationContext.newSchema(schemaLocationOfSchema, evaluationPathOfSchema, node, parentSchema);
                continue;
            }
            if (!keyword.equals("else") || node == null) continue;
            foundElseSchema = validationContext.newSchema(schemaLocationOfSchema, evaluationPathOfSchema, node, parentSchema);
        }
        this.ifSchema = foundIfSchema;
        this.thenSchema = foundThenSchema;
        this.elseSchema = foundElseSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation) {
        IfValidator.debug(logger, executionContext, node, rootNode, instanceLocation);
        boolean ifConditionPassed = false;
        boolean failFast = executionContext.isFailFast();
        try {
            executionContext.setFailFast(false);
            ifConditionPassed = this.ifSchema.validate(executionContext, node, rootNode, instanceLocation).isEmpty();
        }
        finally {
            executionContext.setFailFast(failFast);
        }
        if (ifConditionPassed && this.thenSchema != null) {
            return this.thenSchema.validate(executionContext, node, rootNode, instanceLocation);
        }
        if (!ifConditionPassed && this.elseSchema != null) {
            return this.elseSchema.validate(executionContext, node, rootNode, instanceLocation);
        }
        return Collections.emptySet();
    }

    @Override
    public void preloadJsonSchema() {
        if (null != this.ifSchema) {
            this.ifSchema.initializeValidators();
        }
        if (null != this.thenSchema) {
            this.thenSchema.initializeValidators();
        }
        if (null != this.elseSchema) {
            this.elseSchema.initializeValidators();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ValidationMessage> walk(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation, boolean shouldValidateSchema) {
        boolean checkCondition = node != null && shouldValidateSchema;
        boolean ifConditionPassed = false;
        boolean failFast = executionContext.isFailFast();
        try {
            executionContext.setFailFast(false);
            ifConditionPassed = this.ifSchema.walk(executionContext, node, rootNode, instanceLocation, shouldValidateSchema).isEmpty();
        }
        finally {
            executionContext.setFailFast(failFast);
        }
        if (!checkCondition) {
            if (this.thenSchema != null) {
                this.thenSchema.walk(executionContext, node, rootNode, instanceLocation, shouldValidateSchema);
            }
            if (this.elseSchema != null) {
                this.elseSchema.walk(executionContext, node, rootNode, instanceLocation, shouldValidateSchema);
            }
        } else {
            if (this.thenSchema != null && ifConditionPassed) {
                return this.thenSchema.walk(executionContext, node, rootNode, instanceLocation, shouldValidateSchema);
            }
            if (this.elseSchema != null && !ifConditionPassed) {
                return this.elseSchema.walk(executionContext, node, rootNode, instanceLocation, shouldValidateSchema);
            }
        }
        return Collections.emptySet();
    }
}

