/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema.regex;

import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.joni.Regex;
import org.joni.Syntax;
import org.joni.exception.SyntaxException;
import wiremock.com.networknt.schema.regex.RegularExpression;

class JoniRegularExpression
implements RegularExpression {
    private final Regex pattern;
    private final Pattern INVALID_ESCAPE_PATTERN = Pattern.compile(".*\\\\([aeg-jl-moqyzACE-OQ-RT-VX-Z1-9]|k([^<]|$)|c$|[pP]([^{]|$)|u([^{0-9]|$)|x([0-9a-fA-F][^0-9a-fA-F]|[^0-9a-fA-F][0-9a-fA-F]|[^0-9a-fA-F][^0-9a-fA-F]|.?$)).*");
    private static final Syntax SYNTAX = new Syntax(Syntax.ECMAScript.name, Syntax.ECMAScript.op, Syntax.ECMAScript.op2 | 0x80 | 0x100, Syntax.ECMAScript.op3, Syntax.ECMAScript.behavior, Syntax.ECMAScript.options, Syntax.ECMAScript.metaCharTable);

    JoniRegularExpression(String regex) {
        this(regex, SYNTAX);
    }

    JoniRegularExpression(String regex, Syntax syntax) {
        this.validate(regex);
        String s2 = regex.replace("\\d", "[0-9]").replace("\\D", "[^0-9]").replace("\\w", "[a-zA-Z0-9_]").replace("\\W", "[^a-zA-Z0-9_]").replace("\\s", "[ \\f\\n\\r\\t\\v\\u00a0\\u1680\\u2000-\\u200a\\u2028\\u2029\\u202f\\u205f\\u3000\\ufeff]").replace("\\S", "[^ \\f\\n\\r\\t\\v\\u00a0\\u1680\\u2000-\\u200a\\u2028\\u2029\\u202f\\u205f\\u3000\\ufeff]");
        byte[] bytes = s2.getBytes(StandardCharsets.UTF_8);
        this.pattern = new Regex(bytes, 0, bytes.length, 8, (Encoding)UTF8Encoding.INSTANCE, syntax);
    }

    protected void validate(String regex) {
        if (this.INVALID_ESCAPE_PATTERN.matcher(regex).matches()) {
            throw new SyntaxException("Invalid escape");
        }
    }

    @Override
    public boolean matches(String value) {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        return this.pattern.matcher(bytes).search(0, bytes.length, 0) >= 0;
    }
}

