/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema.walk;

import java.util.List;
import java.util.Map;
import java.util.Set;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.networknt.schema.JsonSchema;
import wiremock.com.networknt.schema.JsonSchemaFactory;
import wiremock.com.networknt.schema.ValidationContext;
import wiremock.com.networknt.schema.ValidationMessage;
import wiremock.com.networknt.schema.walk.AbstractWalkListenerRunner;
import wiremock.com.networknt.schema.walk.JsonSchemaWalkListener;
import wiremock.com.networknt.schema.walk.WalkEvent;

public class DefaultKeywordWalkListenerRunner
extends AbstractWalkListenerRunner {
    private Map<String, List<JsonSchemaWalkListener>> keywordWalkListenersMap;

    public DefaultKeywordWalkListenerRunner(Map<String, List<JsonSchemaWalkListener>> keywordWalkListenersMap) {
        this.keywordWalkListenersMap = keywordWalkListenersMap;
    }

    protected String getKeywordName(String keyWordPath) {
        return keyWordPath.substring(keyWordPath.lastIndexOf(47) + 1);
    }

    @Override
    public boolean runPreWalkListeners(String keyWordPath, JsonNode node, JsonNode rootNode, String at, String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext, JsonSchemaFactory currentJsonSchemaFactory) {
        String keyword = this.getKeywordName(keyWordPath);
        boolean continueRunningListenersAndWalk = true;
        WalkEvent keywordWalkEvent = this.constructWalkEvent(keyword, node, rootNode, at, schemaPath, schemaNode, parentSchema, validationContext, currentJsonSchemaFactory);
        List<JsonSchemaWalkListener> currentKeywordListeners = this.keywordWalkListenersMap.get(keyword);
        continueRunningListenersAndWalk = this.runPreWalkListeners(currentKeywordListeners, keywordWalkEvent);
        if (continueRunningListenersAndWalk) {
            List<JsonSchemaWalkListener> allKeywordListeners = this.keywordWalkListenersMap.get("wiremock.com.networknt.AllKeywordWalkListener");
            this.runPreWalkListeners(allKeywordListeners, keywordWalkEvent);
        }
        return continueRunningListenersAndWalk;
    }

    @Override
    public void runPostWalkListeners(String keyWordPath, JsonNode node, JsonNode rootNode, String at, String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext, JsonSchemaFactory currentJsonSchemaFactory, Set<ValidationMessage> validationMessages) {
        String keyword = this.getKeywordName(keyWordPath);
        WalkEvent keywordWalkEvent = this.constructWalkEvent(keyword, node, rootNode, at, schemaPath, schemaNode, parentSchema, validationContext, currentJsonSchemaFactory);
        List<JsonSchemaWalkListener> currentKeywordListeners = this.keywordWalkListenersMap.get(keyword);
        this.runPostWalkListeners(currentKeywordListeners, keywordWalkEvent, validationMessages);
        List<JsonSchemaWalkListener> allKeywordListeners = this.keywordWalkListenersMap.get("wiremock.com.networknt.AllKeywordWalkListener");
        this.runPostWalkListeners(allKeywordListeners, keywordWalkEvent, validationMessages);
    }
}

