/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema;

import java.util.Optional;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.networknt.schema.JsonSchemaException;
import wiremock.com.networknt.schema.JsonSchemaFactory;
import wiremock.com.networknt.schema.SpecVersion;

public final class SpecVersionDetector {
    private static final String SCHEMA_TAG = "$schema";

    private SpecVersionDetector() {
    }

    public static SpecVersion.VersionFlag detect(JsonNode jsonNode) {
        return SpecVersionDetector.detectOptionalVersion(jsonNode).orElseThrow(() -> new JsonSchemaException("'$schema' tag is not present"));
    }

    public static Optional<SpecVersion.VersionFlag> detectOptionalVersion(JsonNode jsonNode) {
        return Optional.ofNullable(jsonNode.get(SCHEMA_TAG)).map(schemaTag -> {
            String schemaTagValue = schemaTag.asText();
            String schemaUri = JsonSchemaFactory.normalizeMetaSchemaUri(schemaTagValue);
            return SpecVersion.VersionFlag.fromId(schemaUri).orElseThrow(() -> new JsonSchemaException("'" + schemaTagValue + "' is unrecognizable schema"));
        });
    }

    public static Optional<SpecVersion.VersionFlag> detectOptionalVersion(String schemaUri) {
        return SpecVersion.VersionFlag.fromId(schemaUri);
    }
}

