/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.ethlo.time;

import java.time.DateTimeException;
import java.time.ZoneOffset;
import java.util.Objects;

public class TimezoneOffset {
    public static final TimezoneOffset UTC = new TimezoneOffset(0, 0);
    private final int hours;
    private final int minutes;

    private TimezoneOffset(int hours, int minutes) {
        if (hours > 0 && minutes < 0) {
            throw new DateTimeException("Zone offset minutes must be positive because hours is positive");
        }
        if (hours < 0 && minutes > 0) {
            throw new DateTimeException("Zone offset minutes must be negative because hours is negative");
        }
        this.hours = hours;
        this.minutes = minutes;
    }

    public static TimezoneOffset ofHoursMinutes(int hours, int minutes) {
        return new TimezoneOffset(hours, minutes);
    }

    public static TimezoneOffset of(ZoneOffset offset) {
        int seconds = offset.getTotalSeconds();
        int hours = seconds / 3600;
        int remainder = seconds % 3600;
        int minutes = remainder / 60;
        return TimezoneOffset.ofHoursMinutes(hours, minutes);
    }

    public int getHours() {
        return this.hours;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getTotalSeconds() {
        return this.hours * 60 * 60 + this.minutes * 60;
    }

    public ZoneOffset toZoneOffset() {
        if (this.equals(UTC)) {
            return ZoneOffset.UTC;
        }
        return ZoneOffset.ofHoursMinutes(this.hours, this.minutes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimezoneOffset that = (TimezoneOffset)o;
        return this.hours == that.hours && this.minutes == that.minutes;
    }

    public int hashCode() {
        return Objects.hash(this.hours, this.minutes);
    }

    public String toString() {
        return "TimezoneOffset{hours=" + this.hours + ", minutes=" + this.minutes + '}';
    }
}

