/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class SystemKeyAuthoriser {
    private final Set<Pattern> regexes = new HashSet<Pattern>();

    public SystemKeyAuthoriser(Set<String> patterns) {
        if (patterns == null || patterns.isEmpty()) {
            patterns = Set.of("wiremock.*");
        }
        for (String pattern : patterns) {
            this.regexes.add(Pattern.compile(pattern, 2));
        }
    }

    public boolean isPermitted(String key) {
        for (Pattern regex : this.regexes) {
            if (!regex.matcher(key).matches()) continue;
            return true;
        }
        return false;
    }
}

