/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.Errors;
import com.github.tomakehurst.wiremock.common.InvalidInputException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;
import java.util.regex.Pattern;
import wiremock.com.google.common.net.InetAddresses;

public abstract class NetworkAddressRange {
    public static final NetworkAddressRange ALL = new All();
    private static final Pattern SINGLE_IP = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}");
    private static final Pattern IP_RANGE = Pattern.compile(SINGLE_IP.pattern() + "-" + SINGLE_IP.pattern());

    public static NetworkAddressRange of(String value) {
        if (SINGLE_IP.matcher(value).matches()) {
            return new SingleIp(value);
        }
        if (IP_RANGE.matcher(value).matches()) {
            return new IpRange(value);
        }
        return new DomainNameWildcard(value);
    }

    public abstract boolean isIncluded(String var1);

    private static InetAddress parseIpAddress(String ipAddress) {
        if (!InetAddresses.isInetAddress(ipAddress)) {
            throw new InvalidInputException(Errors.single(16, ipAddress + " is not a valid IP address"));
        }
        return NetworkAddressRange.lookup(ipAddress);
    }

    private static InetAddress lookup(String host) {
        try {
            return InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            throw new InvalidInputException(e, Errors.single(17, host + " is not a valid network address"));
        }
    }

    private static class All
    extends NetworkAddressRange {
        private All() {
        }

        @Override
        public boolean isIncluded(String testValue) {
            return true;
        }
    }

    private static class DomainNameWildcard
    extends NetworkAddressRange {
        private final Pattern namePattern;

        private DomainNameWildcard(String namePattern) {
            String nameRegex = namePattern.replace(".", "\\.").replace("*", ".+");
            this.namePattern = Pattern.compile(nameRegex);
        }

        @Override
        public boolean isIncluded(String testValue) {
            return this.namePattern.matcher(testValue).matches();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DomainNameWildcard that = (DomainNameWildcard)o;
            return this.namePattern.equals(that.namePattern);
        }

        public int hashCode() {
            return Objects.hash(this.namePattern);
        }
    }

    private static class IpRange
    extends NetworkAddressRange {
        private final BigInteger start;
        private final BigInteger end;

        private IpRange(String ipRange) {
            String[] parts = ipRange.split("-");
            if (parts.length != 2) {
                throw new InvalidInputException(Errors.single(18, ipRange + " is not a valid IP range"));
            }
            this.start = InetAddresses.toBigInteger(NetworkAddressRange.parseIpAddress(parts[0]));
            this.end = InetAddresses.toBigInteger(NetworkAddressRange.parseIpAddress(parts[1]));
        }

        @Override
        public boolean isIncluded(String testValue) {
            InetAddress testValueAddress = NetworkAddressRange.lookup(testValue);
            BigInteger intVal = InetAddresses.toBigInteger(testValueAddress);
            return intVal.compareTo(this.start) >= 0 && intVal.compareTo(this.end) <= 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IpRange ipRange = (IpRange)o;
            return this.start.equals(ipRange.start) && this.end.equals(ipRange.end);
        }

        public int hashCode() {
            return Objects.hash(this.start, this.end);
        }
    }

    private static class SingleIp
    extends NetworkAddressRange {
        private final InetAddress inetAddress;

        private SingleIp(String ipAddress) {
            this.inetAddress = NetworkAddressRange.parseIpAddress(ipAddress);
        }

        @Override
        public boolean isIncluded(String testValue) {
            return NetworkAddressRange.lookup(testValue).equals(this.inetAddress);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SingleIp singleIp = (SingleIp)o;
            return this.inetAddress.equals(singleIp.inetAddress);
        }

        public int hashCode() {
            return Objects.hash(this.inetAddress);
        }
    }
}

