/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.recording;

import com.github.tomakehurst.wiremock.common.Pair;
import com.github.tomakehurst.wiremock.recording.RecordError;
import com.github.tomakehurst.wiremock.recording.ResponseDefinitionBodyMatcher;
import com.github.tomakehurst.wiremock.recording.ScenarioProcessor;
import com.github.tomakehurst.wiremock.recording.SnapshotStubMappingBodyExtractor;
import com.github.tomakehurst.wiremock.recording.SnapshotStubMappingTransformerRunner;
import com.github.tomakehurst.wiremock.recording.StubGenerationResult;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.google.common.collect.HashMultiset;
import java.util.ArrayList;
import java.util.List;

class SnapshotStubMappingPostProcessor {
    private final boolean shouldRecordRepeatsAsScenarios;
    private final SnapshotStubMappingTransformerRunner transformerRunner;
    private final ResponseDefinitionBodyMatcher bodyExtractMatcher;
    private final SnapshotStubMappingBodyExtractor bodyExtractor;

    SnapshotStubMappingPostProcessor(boolean shouldRecordRepeatsAsScenarios, SnapshotStubMappingTransformerRunner transformerRunner, ResponseDefinitionBodyMatcher bodyExtractMatcher, SnapshotStubMappingBodyExtractor bodyExtractor) {
        this.shouldRecordRepeatsAsScenarios = shouldRecordRepeatsAsScenarios;
        this.transformerRunner = transformerRunner;
        this.bodyExtractMatcher = bodyExtractMatcher;
        this.bodyExtractor = bodyExtractor;
    }

    Pair<List<RecordError>, List<StubMapping>> process(List<Pair<ServeEvent, StubMapping>> serveEventsToStubMappings) {
        ArrayList<StubMapping> transformedStubMappings = new ArrayList<StubMapping>();
        ArrayList<RecordError.StubGenerationFailure> errors = new ArrayList<RecordError.StubGenerationFailure>();
        for (Pair<ServeEvent, StubMapping> serveEventToStubMapping : serveEventsToStubMappings) {
            StubGenerationResult result = this.transformerRunner.apply(serveEventToStubMapping);
            if (result instanceof StubGenerationResult.Success) {
                StubGenerationResult.Success success = (StubGenerationResult.Success)result;
                transformedStubMappings.add(success.stubMapping());
                continue;
            }
            if (result instanceof StubGenerationResult.Failure) {
                StubGenerationResult.Failure failure = (StubGenerationResult.Failure)result;
                errors.add(new RecordError.StubGenerationFailure(failure.reason(), (ServeEvent)serveEventToStubMapping.a));
                continue;
            }
            throw new IllegalStateException("Unexpected result: " + String.valueOf(result));
        }
        HashMultiset requestCounts = HashMultiset.create();
        ArrayList<StubMapping> processedStubMappings = new ArrayList<StubMapping>();
        for (StubMapping transformedStubMapping : transformedStubMappings) {
            requestCounts.add((Object)transformedStubMapping.getRequest());
            if (requestCounts.count((Object)transformedStubMapping.getRequest()) > 1 && !this.shouldRecordRepeatsAsScenarios) continue;
            processedStubMappings.add(transformedStubMapping);
        }
        if (this.shouldRecordRepeatsAsScenarios) {
            new ScenarioProcessor().putRepeatedRequestsInScenarios(processedStubMappings);
        }
        this.extractStubMappingBodies(processedStubMappings);
        return new Pair<List<RecordError>, List<StubMapping>>(errors, processedStubMappings);
    }

    private void extractStubMappingBodies(List<StubMapping> stubMappings) {
        if (this.bodyExtractMatcher == null) {
            return;
        }
        for (StubMapping stubMapping : stubMappings) {
            if (!this.bodyExtractMatcher.match(stubMapping.getResponse()).isExactMatch()) continue;
            this.bodyExtractor.extractInPlace(stubMapping);
        }
    }
}

