/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.Exceptions;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class KeyLocks {
    private final ConcurrentHashMap<String, LockWrapper> locks = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T withLock(String key, Callable<T> action) {
        try {
            this.lock(key);
            Object object = Exceptions.uncheck(action::call, Object.class);
            return (T)object;
        }
        finally {
            this.unlock(key);
        }
    }

    private void lock(String key) {
        LockWrapper lockWrapper = this.locks.compute(key, (k, v) -> v == null ? new LockWrapper() : v.addThreadInQueue());
        lockWrapper.lock.lock();
    }

    private void unlock(String key) {
        LockWrapper lockWrapper = this.locks.get(key);
        lockWrapper.lock.unlock();
        if (lockWrapper.removeThreadFromQueue() == 0) {
            this.locks.remove(key, lockWrapper);
        }
    }

    private static class LockWrapper {
        private final Lock lock = new ReentrantLock();
        private final AtomicInteger numberOfThreadsInQueue = new AtomicInteger(1);

        private LockWrapper() {
        }

        private LockWrapper addThreadInQueue() {
            this.numberOfThreadsInQueue.incrementAndGet();
            return this;
        }

        private int removeThreadFromQueue() {
            return this.numberOfThreadsInQueue.decrementAndGet();
        }
    }
}

