/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating;

import com.github.tomakehurst.wiremock.common.ListOrSingle;
import com.github.tomakehurst.wiremock.common.Urls;
import com.github.tomakehurst.wiremock.common.url.PathParams;
import com.github.tomakehurst.wiremock.extension.responsetemplating.TemplatedUrlPath;
import com.github.tomakehurst.wiremock.extension.responsetemplating.UrlPath;
import com.github.tomakehurst.wiremock.http.QueryParameter;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class RequestLine {
    private final RequestMethod method;
    private final String scheme;
    private final String host;
    private final int port;
    private final Map<String, ListOrSingle<String>> query;
    private final String url;
    private final String clientIp;
    private final PathParams pathParams;

    private RequestLine(RequestMethod method, String scheme, String host, int port, String url, String clientIp, Map<String, ListOrSingle<String>> query, PathParams pathParams) {
        this.method = method;
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        this.url = url;
        this.clientIp = clientIp;
        this.query = query;
        this.pathParams = pathParams;
    }

    public static RequestLine fromRequest(Request request) {
        Map<String, QueryParameter> rawQuery = Urls.splitQueryFromUrl(request.getUrl());
        Map adaptedQuery = rawQuery.entrySet().stream().map(entry -> Map.entry((String)entry.getKey(), ListOrSingle.of(((QueryParameter)entry.getValue()).values()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        return new RequestLine(request.getMethod(), request.getScheme(), request.getHost(), request.getPort(), request.getUrl(), request.getClientIp(), adaptedQuery, request.getPathParameters());
    }

    public RequestMethod getMethod() {
        return this.method;
    }

    public Object getPathSegments() {
        return this.pathParams.isEmpty() ? new UrlPath(this.url) : new TemplatedUrlPath(this.url, this.pathParams);
    }

    public String getPath() {
        return this.getPathSegments().toString();
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, ListOrSingle<String>> getQuery() {
        return this.query;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getBaseUrl() {
        String portPart = this.isStandardPort(this.scheme, this.port) ? "" : ":" + this.port;
        return this.scheme + "://" + this.host + portPart;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    private boolean isStandardPort(String scheme, int port) {
        return scheme.equals("http") && port == 80 || scheme.equals("https") && port == 443;
    }
}

