/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.core;

import com.github.tomakehurst.wiremock.common.AsynchronousResponseSettings;
import com.github.tomakehurst.wiremock.common.BrowserProxySettings;
import com.github.tomakehurst.wiremock.common.ClasspathFileSource;
import com.github.tomakehurst.wiremock.common.DataTruncationSettings;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.HttpsSettings;
import com.github.tomakehurst.wiremock.common.Limit;
import com.github.tomakehurst.wiremock.common.NetworkAddressRules;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.common.ProxySettings;
import com.github.tomakehurst.wiremock.common.ResourceUtil;
import com.github.tomakehurst.wiremock.common.SingleRootFileSource;
import com.github.tomakehurst.wiremock.common.Slf4jNotifier;
import com.github.tomakehurst.wiremock.common.filemaker.FilenameMaker;
import com.github.tomakehurst.wiremock.common.ssl.KeyStoreSettings;
import com.github.tomakehurst.wiremock.common.ssl.KeyStoreSourceFactory;
import com.github.tomakehurst.wiremock.core.MappingsSaver;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.extension.ExtensionDeclarations;
import com.github.tomakehurst.wiremock.extension.ExtensionFactory;
import com.github.tomakehurst.wiremock.extension.Extensions;
import com.github.tomakehurst.wiremock.global.GlobalSettings;
import com.github.tomakehurst.wiremock.http.CaseInsensitiveKey;
import com.github.tomakehurst.wiremock.http.HttpServerFactory;
import com.github.tomakehurst.wiremock.http.client.ApacheHttpClientFactory;
import com.github.tomakehurst.wiremock.http.client.HttpClientFactory;
import com.github.tomakehurst.wiremock.http.trafficlistener.DoNothingWiremockNetworkTrafficListener;
import com.github.tomakehurst.wiremock.http.trafficlistener.WiremockNetworkTrafficListener;
import com.github.tomakehurst.wiremock.security.Authenticator;
import com.github.tomakehurst.wiremock.security.BasicAuthenticator;
import com.github.tomakehurst.wiremock.security.NoAuthenticator;
import com.github.tomakehurst.wiremock.standalone.JsonFileMappingsSource;
import com.github.tomakehurst.wiremock.standalone.MappingsLoader;
import com.github.tomakehurst.wiremock.standalone.MappingsSource;
import com.github.tomakehurst.wiremock.store.DefaultStores;
import com.github.tomakehurst.wiremock.store.Stores;
import com.github.tomakehurst.wiremock.verification.notmatched.NotMatchedRenderer;
import com.github.tomakehurst.wiremock.verification.notmatched.PlainTextStubNotMatchedRenderer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class WireMockConfiguration
implements Options {
    private long asyncResponseTimeout = 300000L;
    private boolean disableOptimizeXmlFactoriesLoading = false;
    private int portNumber = 8080;
    private boolean httpDisabled = false;
    private boolean http2PlainDisabled = false;
    private boolean http2TlsDisabled = false;
    private String bindAddress = "0.0.0.0";
    private int containerThreads = 25;
    private int httpsPort = -1;
    private String keyStorePath = ResourceUtil.getResource(WireMockConfiguration.class, "keystore").toString();
    private String keyStorePassword = "password";
    private String keyManagerPassword = "password";
    private String keyStoreType = "JKS";
    private String trustStorePath;
    private String trustStorePassword = "password";
    private String trustStoreType = "JKS";
    private boolean needClientAuth;
    private boolean browserProxyingEnabled = false;
    private String caKeystorePath = BrowserProxySettings.DEFAULT_CA_KEYSTORE_PATH;
    private String caKeystorePassword = "password";
    private String caKeystoreType = "JKS";
    private KeyStoreSettings caKeyStoreSettings = null;
    private boolean trustAllProxyTargets = false;
    private final List<String> trustedProxyTargets = new ArrayList<String>();
    private ProxySettings proxySettings = ProxySettings.NO_PROXY;
    private FileSource filesRoot = new SingleRootFileSource("src/test/resources");
    private Stores stores;
    private MappingsSource mappingsSource;
    private FilenameMaker filenameMaker;
    private Notifier notifier = new Slf4jNotifier(false);
    private boolean requestJournalDisabled = false;
    private Optional<Integer> maxRequestJournalEntries = Optional.empty();
    private List<CaseInsensitiveKey> matchingHeaders = Collections.emptyList();
    private boolean preserveHostHeader;
    private boolean preserveUserAgentProxyHeader;
    private String proxyHostHeader;
    private HttpServerFactory httpServerFactory = null;
    private HttpClientFactory httpClientFactory = new ApacheHttpClientFactory();
    private ExtensionDeclarations extensions = new ExtensionDeclarations();
    private boolean extensionScanningEnabled = false;
    private WiremockNetworkTrafficListener networkTrafficListener = new DoNothingWiremockNetworkTrafficListener();
    private Authenticator adminAuthenticator = new NoAuthenticator();
    private boolean requireHttpsForAdminApi = false;
    private Function<Extensions, NotMatchedRenderer> notMatchedRendererFactory = PlainTextStubNotMatchedRenderer::new;
    private boolean asynchronousResponseEnabled;
    private int asynchronousResponseThreads;
    private Options.ChunkedEncodingPolicy chunkedEncodingPolicy;
    private boolean gzipDisabled = false;
    private boolean stubLoggingDisabled = false;
    private boolean stubCorsEnabled = false;
    private boolean disableStrictHttpHeaders;
    private boolean proxyPassThrough = true;
    private Limit responseBodySizeLimit = Limit.UNLIMITED;
    private NetworkAddressRules proxyTargetRules = NetworkAddressRules.ALLOW_ALL;
    private int proxyTimeout = 300000;
    private int maxHttpClientConnections = 1000;
    private boolean disableConnectionReuse = true;
    private boolean templatingEnabled = true;
    private boolean globalTemplating = false;
    private Set<String> permittedSystemKeys = null;
    private Long maxTemplateCacheEntries = DEFAULT_MAX_TEMPLATE_CACHE_ENTRIES;
    private boolean templateEscapingDisabled = true;
    private Set<String> supportedProxyEncodings = null;
    private int webhookThreadPoolSize = 10;

    private MappingsSource getMappingsSource() {
        if (this.mappingsSource == null) {
            this.mappingsSource = new JsonFileMappingsSource(this.filesRoot.child("mappings"), this.getFilenameMaker());
        }
        return this.mappingsSource;
    }

    public static WireMockConfiguration wireMockConfig() {
        return new WireMockConfiguration();
    }

    public static WireMockConfiguration options() {
        return WireMockConfiguration.wireMockConfig();
    }

    public WireMockConfiguration proxyPassThrough(boolean proxyPassThrough) {
        this.proxyPassThrough = proxyPassThrough;
        GlobalSettings newSettings = this.getStores().getSettingsStore().get().copy().proxyPassThrough(proxyPassThrough).build();
        this.getStores().getSettingsStore().set(newSettings);
        return this;
    }

    public WireMockConfiguration timeout(int timeout) {
        this.asyncResponseTimeout = timeout;
        return this;
    }

    public WireMockConfiguration port(int portNumber) {
        this.portNumber = portNumber;
        return this;
    }

    public WireMockConfiguration filenameTemplate(String filenameTemplate) {
        this.filenameMaker = new FilenameMaker(filenameTemplate);
        return this;
    }

    public WireMockConfiguration dynamicPort() {
        this.portNumber = 0;
        return this;
    }

    public WireMockConfiguration httpDisabled(boolean httpDisabled) {
        this.httpDisabled = httpDisabled;
        return this;
    }

    public WireMockConfiguration http2PlainDisabled(boolean enabled) {
        this.http2PlainDisabled = enabled;
        return this;
    }

    public WireMockConfiguration http2TlsDisabled(boolean enabled) {
        this.http2TlsDisabled = enabled;
        return this;
    }

    public WireMockConfiguration httpsPort(Integer httpsPort) {
        this.httpsPort = httpsPort;
        return this;
    }

    public WireMockConfiguration dynamicHttpsPort() {
        this.httpsPort = 0;
        return this;
    }

    public WireMockConfiguration containerThreads(Integer containerThreads) {
        this.containerThreads = containerThreads;
        return this;
    }

    public WireMockConfiguration keystorePath(String path) {
        this.keyStorePath = path;
        return this;
    }

    public WireMockConfiguration keystorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
        return this;
    }

    public WireMockConfiguration keyManagerPassword(String keyManagerPassword) {
        this.keyManagerPassword = keyManagerPassword;
        return this;
    }

    public WireMockConfiguration keystoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
        return this;
    }

    public WireMockConfiguration caKeystoreSettings(KeyStoreSettings caKeyStoreSettings) {
        this.caKeyStoreSettings = caKeyStoreSettings;
        return this;
    }

    public WireMockConfiguration caKeystorePath(String path) {
        this.caKeystorePath = path;
        return this;
    }

    public WireMockConfiguration caKeystorePassword(String keyStorePassword) {
        this.caKeystorePassword = keyStorePassword;
        return this;
    }

    public WireMockConfiguration caKeystoreType(String caKeystoreType) {
        this.caKeystoreType = caKeystoreType;
        return this;
    }

    public WireMockConfiguration trustStorePath(String truststorePath) {
        this.trustStorePath = truststorePath;
        return this;
    }

    public WireMockConfiguration trustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
        return this;
    }

    public WireMockConfiguration trustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
        return this;
    }

    public WireMockConfiguration needClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
        return this;
    }

    public WireMockConfiguration enableBrowserProxying(boolean enabled) {
        this.browserProxyingEnabled = enabled;
        return this;
    }

    public WireMockConfiguration proxyVia(String host, int port) {
        this.proxySettings = new ProxySettings(host, port);
        return this;
    }

    public WireMockConfiguration proxyVia(ProxySettings proxySettings) {
        this.proxySettings = proxySettings;
        return this;
    }

    public WireMockConfiguration withStores(Stores stores) {
        this.stores = stores;
        return this;
    }

    public WireMockConfiguration withRootDirectory(String path) {
        this.filesRoot = new SingleRootFileSource(path);
        return this;
    }

    public WireMockConfiguration usingFilesUnderDirectory(String path) {
        return this.withRootDirectory(path);
    }

    public WireMockConfiguration usingFilesUnderClasspath(String path) {
        this.fileSource(new ClasspathFileSource(path));
        return this;
    }

    public WireMockConfiguration fileSource(FileSource fileSource) {
        this.filesRoot = fileSource;
        return this;
    }

    public WireMockConfiguration mappingSource(MappingsSource mappingsSource) {
        this.mappingsSource = mappingsSource;
        return this;
    }

    public WireMockConfiguration notifier(Notifier notifier) {
        this.notifier = notifier;
        return this;
    }

    public WireMockConfiguration bindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
        return this;
    }

    public WireMockConfiguration disableRequestJournal() {
        this.requestJournalDisabled = true;
        return this;
    }

    @Deprecated
    public WireMockConfiguration maxRequestJournalEntries(Optional<Integer> maxRequestJournalEntries) {
        this.maxRequestJournalEntries = maxRequestJournalEntries;
        return this;
    }

    public WireMockConfiguration maxRequestJournalEntries(int maxRequestJournalEntries) {
        this.maxRequestJournalEntries = Optional.of(maxRequestJournalEntries);
        return this;
    }

    public WireMockConfiguration recordRequestHeadersForMatching(List<String> headers) {
        this.matchingHeaders = headers.stream().map(CaseInsensitiveKey.TO_CASE_INSENSITIVE_KEYS).collect(Collectors.toUnmodifiableList());
        return this;
    }

    public WireMockConfiguration preserveHostHeader(boolean preserveHostHeader) {
        this.preserveHostHeader = preserveHostHeader;
        return this;
    }

    public WireMockConfiguration preserveUserAgentProxyHeader(boolean preserveUserAgentProxyHeader) {
        this.preserveUserAgentProxyHeader = preserveUserAgentProxyHeader;
        return this;
    }

    public WireMockConfiguration proxyHostHeader(String hostHeaderValue) {
        this.proxyHostHeader = hostHeaderValue;
        return this;
    }

    public WireMockConfiguration extensions(String ... classNames) {
        this.extensions.add(classNames);
        return this;
    }

    public WireMockConfiguration extensions(Extension ... extensionInstances) {
        this.extensions.add(extensionInstances);
        return this;
    }

    public WireMockConfiguration extensionFactories(ExtensionFactory ... extensionFactories) {
        return this.extensions(extensionFactories);
    }

    public WireMockConfiguration extensions(ExtensionFactory ... extensionFactories) {
        this.extensions.add(extensionFactories);
        return this;
    }

    public WireMockConfiguration extensions(Class<? extends Extension> ... classes) {
        this.extensions.add(classes);
        return this;
    }

    public WireMockConfiguration extensionFactories(Class<? extends ExtensionFactory> ... factoryClasses) {
        this.extensions.addFactories(factoryClasses);
        return this;
    }

    public WireMockConfiguration extensionScanningEnabled(boolean enabled) {
        this.extensionScanningEnabled = enabled;
        return this;
    }

    public WireMockConfiguration httpServerFactory(HttpServerFactory serverFactory) {
        this.httpServerFactory = serverFactory;
        return this;
    }

    public WireMockConfiguration httpClientFactory(HttpClientFactory httpClientFactory) {
        this.httpClientFactory = httpClientFactory;
        return this;
    }

    public WireMockConfiguration networkTrafficListener(WiremockNetworkTrafficListener networkTrafficListener) {
        this.networkTrafficListener = networkTrafficListener;
        return this;
    }

    public WireMockConfiguration adminAuthenticator(Authenticator authenticator) {
        this.adminAuthenticator = authenticator;
        return this;
    }

    public WireMockConfiguration basicAdminAuthenticator(String username, String password) {
        return this.adminAuthenticator(new BasicAuthenticator(username, password));
    }

    public WireMockConfiguration requireHttpsForAdminApi() {
        this.requireHttpsForAdminApi = true;
        return this;
    }

    public WireMockConfiguration notMatchedRendererFactory(Function<Extensions, NotMatchedRenderer> notMatchedRendererFactory) {
        this.notMatchedRendererFactory = notMatchedRendererFactory;
        return this;
    }

    public WireMockConfiguration asynchronousResponseEnabled(boolean asynchronousResponseEnabled) {
        this.asynchronousResponseEnabled = asynchronousResponseEnabled;
        return this;
    }

    public WireMockConfiguration asynchronousResponseThreads(int asynchronousResponseThreads) {
        this.asynchronousResponseThreads = asynchronousResponseThreads;
        return this;
    }

    public WireMockConfiguration useChunkedTransferEncoding(Options.ChunkedEncodingPolicy policy) {
        this.chunkedEncodingPolicy = policy;
        return this;
    }

    public WireMockConfiguration gzipDisabled(boolean gzipDisabled) {
        this.gzipDisabled = gzipDisabled;
        return this;
    }

    public WireMockConfiguration stubRequestLoggingDisabled(boolean disabled) {
        this.stubLoggingDisabled = disabled;
        return this;
    }

    public WireMockConfiguration stubCorsEnabled(boolean enabled) {
        this.stubCorsEnabled = enabled;
        return this;
    }

    public WireMockConfiguration trustAllProxyTargets(boolean enabled) {
        this.trustAllProxyTargets = enabled;
        return this;
    }

    public WireMockConfiguration trustedProxyTargets(String ... trustedProxyTargets) {
        return this.trustedProxyTargets(Arrays.asList(trustedProxyTargets));
    }

    public WireMockConfiguration trustedProxyTargets(List<String> trustedProxyTargets) {
        this.trustedProxyTargets.addAll(trustedProxyTargets);
        return this;
    }

    public WireMockConfiguration disableOptimizeXmlFactoriesLoading(boolean disableOptimizeXmlFactoriesLoading) {
        this.disableOptimizeXmlFactoriesLoading = disableOptimizeXmlFactoriesLoading;
        return this;
    }

    public WireMockConfiguration maxLoggedResponseSize(int maxSize) {
        this.responseBodySizeLimit = new Limit(maxSize);
        return this;
    }

    public WireMockConfiguration limitProxyTargets(NetworkAddressRules proxyTargetRules) {
        this.proxyTargetRules = proxyTargetRules;
        return this;
    }

    public WireMockConfiguration proxyTimeout(int proxyTimeout) {
        this.proxyTimeout = proxyTimeout;
        return this;
    }

    public WireMockConfiguration maxHttpClientConnections(int maxHttpClientConnections) {
        this.maxHttpClientConnections = maxHttpClientConnections;
        return this;
    }

    public WireMockConfiguration disableConnectionReuse(boolean disableConnectionReuse) {
        this.disableConnectionReuse = disableConnectionReuse;
        return this;
    }

    public WireMockConfiguration templatingEnabled(boolean templatingEnabled) {
        this.templatingEnabled = templatingEnabled;
        return this;
    }

    public WireMockConfiguration globalTemplating(boolean globalTemplating) {
        this.globalTemplating = globalTemplating;
        return this;
    }

    public WireMockConfiguration withPermittedSystemKeys(String ... systemKeys) {
        this.permittedSystemKeys = Set.of(systemKeys);
        return this;
    }

    public WireMockConfiguration withTemplateEscapingDisabled(boolean templateEscapingDisabled) {
        this.templateEscapingDisabled = templateEscapingDisabled;
        return this;
    }

    public WireMockConfiguration withMaxTemplateCacheEntries(Long maxTemplateCacheEntries) {
        this.maxTemplateCacheEntries = maxTemplateCacheEntries;
        return this;
    }

    public WireMockConfiguration withSupportedProxyEncodings(Set<String> supportedProxyEncodings) {
        this.supportedProxyEncodings = supportedProxyEncodings;
        return this;
    }

    public WireMockConfiguration withSupportedProxyEncodings(String ... supportedProxyEncodings) {
        return this.withSupportedProxyEncodings(Set.of(supportedProxyEncodings));
    }

    public WireMockConfiguration withWebhookThreadPoolSize(Integer webhookThreadPoolSize) {
        this.webhookThreadPoolSize = webhookThreadPoolSize;
        return this;
    }

    @Override
    public int portNumber() {
        return this.portNumber;
    }

    @Override
    public boolean getHttpDisabled() {
        return this.httpDisabled;
    }

    @Override
    public boolean getHttp2PlainDisabled() {
        return this.http2PlainDisabled;
    }

    @Override
    public boolean getHttp2TlsDisabled() {
        return this.http2TlsDisabled;
    }

    @Override
    public int containerThreads() {
        return this.containerThreads;
    }

    @Override
    public HttpsSettings httpsSettings() {
        return new HttpsSettings.Builder().port(this.httpsPort).keyStorePath(this.keyStorePath).keyStorePassword(this.keyStorePassword).keyManagerPassword(this.keyManagerPassword).keyStoreType(this.keyStoreType).trustStorePath(this.trustStorePath).trustStorePassword(this.trustStorePassword).trustStoreType(this.trustStoreType).needClientAuth(this.needClientAuth).build();
    }

    @Override
    public boolean browserProxyingEnabled() {
        return this.browserProxyingEnabled;
    }

    @Override
    public ProxySettings proxyVia() {
        return this.proxySettings;
    }

    @Override
    public Stores getStores() {
        if (this.stores == null) {
            this.stores = new DefaultStores(this.filesRoot);
        }
        return this.stores;
    }

    @Override
    public FileSource filesRoot() {
        return this.filesRoot;
    }

    @Override
    public MappingsLoader mappingsLoader() {
        return this.getMappingsSource();
    }

    @Override
    public MappingsSaver mappingsSaver() {
        return this.getMappingsSource();
    }

    @Override
    public Notifier notifier() {
        return this.notifier;
    }

    @Override
    public boolean requestJournalDisabled() {
        return this.requestJournalDisabled;
    }

    @Override
    public Optional<Integer> maxRequestJournalEntries() {
        return this.maxRequestJournalEntries;
    }

    @Override
    public String bindAddress() {
        return this.bindAddress;
    }

    @Override
    public FilenameMaker getFilenameMaker() {
        return this.filenameMaker;
    }

    @Override
    public List<CaseInsensitiveKey> matchingHeaders() {
        return this.matchingHeaders;
    }

    @Override
    public HttpServerFactory httpServerFactory() {
        return this.httpServerFactory;
    }

    @Override
    public HttpClientFactory httpClientFactory() {
        return this.httpClientFactory;
    }

    @Override
    public boolean shouldPreserveHostHeader() {
        return this.preserveHostHeader;
    }

    @Override
    public boolean shouldPreserveUserAgentProxyHeader() {
        return this.preserveUserAgentProxyHeader;
    }

    @Override
    public String proxyHostHeader() {
        return this.proxyHostHeader;
    }

    @Override
    public ExtensionDeclarations getDeclaredExtensions() {
        return this.extensions;
    }

    @Override
    public boolean isExtensionScanningEnabled() {
        return this.extensionScanningEnabled;
    }

    @Override
    public WiremockNetworkTrafficListener networkTrafficListener() {
        return this.networkTrafficListener;
    }

    @Override
    public Authenticator getAdminAuthenticator() {
        return this.adminAuthenticator;
    }

    @Override
    public boolean getHttpsRequiredForAdminApi() {
        return this.requireHttpsForAdminApi;
    }

    @Override
    public Function<Extensions, NotMatchedRenderer> getNotMatchedRendererFactory() {
        return this.notMatchedRendererFactory;
    }

    @Override
    public AsynchronousResponseSettings getAsynchronousResponseSettings() {
        return new AsynchronousResponseSettings(this.asynchronousResponseEnabled, this.asynchronousResponseThreads);
    }

    @Override
    public Options.ChunkedEncodingPolicy getChunkedEncodingPolicy() {
        return this.chunkedEncodingPolicy;
    }

    @Override
    public boolean getGzipDisabled() {
        return this.gzipDisabled;
    }

    @Override
    public boolean getStubRequestLoggingDisabled() {
        return this.stubLoggingDisabled;
    }

    @Override
    public boolean getStubCorsEnabled() {
        return this.stubCorsEnabled;
    }

    @Override
    public long timeout() {
        return this.asyncResponseTimeout;
    }

    @Override
    public boolean getDisableOptimizeXmlFactoriesLoading() {
        return this.disableOptimizeXmlFactoriesLoading;
    }

    @Override
    public boolean getDisableStrictHttpHeaders() {
        return this.disableStrictHttpHeaders;
    }

    @Override
    public DataTruncationSettings getDataTruncationSettings() {
        return new DataTruncationSettings(this.responseBodySizeLimit);
    }

    public WireMockConfiguration disableStrictHttpHeaders(boolean disableStrictHttpHeaders) {
        this.disableStrictHttpHeaders = disableStrictHttpHeaders;
        return this;
    }

    @Override
    public BrowserProxySettings browserProxySettings() {
        KeyStoreSettings keyStoreSettings = this.caKeyStoreSettings != null ? this.caKeyStoreSettings : new KeyStoreSettings(KeyStoreSourceFactory.getAppropriateForJreVersion(this.caKeystorePath, this.caKeystoreType, this.caKeystorePassword.toCharArray()));
        return new BrowserProxySettings.Builder().enabled(this.browserProxyingEnabled).trustAllProxyTargets(this.trustAllProxyTargets).trustedProxyTargets(this.trustedProxyTargets).caKeyStoreSettings(keyStoreSettings).build();
    }

    @Override
    public NetworkAddressRules getProxyTargetRules() {
        return this.proxyTargetRules;
    }

    @Override
    public int proxyTimeout() {
        return this.proxyTimeout;
    }

    @Override
    public int getMaxHttpClientConnections() {
        return this.maxHttpClientConnections;
    }

    @Override
    public boolean getDisableConnectionReuse() {
        return this.disableConnectionReuse;
    }

    @Override
    public boolean getResponseTemplatingEnabled() {
        return this.templatingEnabled;
    }

    @Override
    public boolean getResponseTemplatingGlobal() {
        return this.globalTemplating;
    }

    @Override
    public Long getMaxTemplateCacheEntries() {
        return this.maxTemplateCacheEntries;
    }

    @Override
    public Set<String> getTemplatePermittedSystemKeys() {
        return this.permittedSystemKeys;
    }

    @Override
    public boolean getTemplateEscapingDisabled() {
        return this.templateEscapingDisabled;
    }

    @Override
    public Set<String> getSupportedProxyEncodings() {
        return this.supportedProxyEncodings;
    }

    @Override
    public int getWebhookThreadPoolSize() {
        return this.webhookThreadPoolSize;
    }
}

