/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.spring.internal;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.test.util.TestPropertyValues;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.core.env.ConfigurableEnvironment;
import org.wiremock.spring.ConfigureWireMock;
import org.wiremock.spring.WireMockConfigurationCustomizer;
import org.wiremock.spring.internal.Slf4jNotifier;
import org.wiremock.spring.internal.Store;

public class WireMockServerCreator {
    private static final int PORT_DISABLED = -1;
    private final Logger logger;

    public WireMockServerCreator(String name) {
        this.logger = LoggerFactory.getLogger((String)(String.valueOf(WireMockServerCreator.class) + " " + name));
    }

    public WireMockServer createWireMockServer(ConfigurableApplicationContext context, ConfigureWireMock options) {
        int serverHttpPort;
        boolean httpEnabled;
        boolean httpsEnabled;
        WireMockConfiguration serverOptions = WireMockConfiguration.options();
        int serverHttpsPort = this.getServerHttpsPortProperty(context.getEnvironment(), options);
        boolean bl = httpsEnabled = serverHttpsPort != -1;
        if (httpsEnabled) {
            serverOptions.httpsPort(Integer.valueOf(serverHttpsPort));
        }
        boolean bl2 = httpEnabled = (serverHttpPort = this.getServerHttpPortProperty(context.getEnvironment(), options)) != -1;
        if (httpEnabled) {
            serverOptions.port(serverHttpPort);
        }
        serverOptions.notifier((Notifier)new Slf4jNotifier(options.name()));
        this.configureMappings(options, serverOptions);
        if (options.extensionFactories().length > 0) {
            serverOptions.extensionFactories((Class[])options.extensionFactories());
        }
        if (options.extensions().length > 0) {
            serverOptions.extensions((Class[])options.extensions());
        }
        serverOptions.globalTemplating(options.globalTemplating());
        this.applyCustomizers(options, serverOptions);
        this.logger.info("Configuring WireMockServer with name '{}' on HTTP port: {} and HTTPS port: {}", new Object[]{options.name(), serverOptions.portNumber(), serverOptions.httpsSettings().port()});
        WireMockServer newServer = new WireMockServer((Options)serverOptions);
        newServer.start();
        this.logger.info("Started WireMockServer with name '{}':{}", (Object)options.name(), (Object)newServer.baseUrl());
        Store.INSTANCE.store((ApplicationContext)context, options.name(), newServer);
        context.addApplicationListener(event -> {
            if (event instanceof ContextClosedEvent) {
                this.logger.info("Stopping WireMockServer with name '{}'", (Object)options.name());
                newServer.stop();
            }
        });
        if (httpEnabled) {
            Arrays.stream(options.baseUrlProperties()).filter(StringUtils::isNotBlank).collect(Collectors.toList()).forEach(propertyName -> {
                String property = propertyName + "=" + String.format("http://localhost:%d", newServer.port());
                this.logger.info("Adding property '{}' with HTTP base URL to Spring application context", (Object)property);
                TestPropertyValues.of((String[])new String[]{property}).applyTo(context.getEnvironment());
            });
            Arrays.stream(options.portProperties()).filter(StringUtils::isNotBlank).collect(Collectors.toList()).forEach(propertyName -> {
                String property = propertyName + "=" + newServer.port();
                this.logger.info("Adding property '{}' with HTTP port to Spring application context", (Object)property);
                TestPropertyValues.of((String[])new String[]{property}).applyTo(context.getEnvironment());
            });
        }
        if (httpsEnabled) {
            Arrays.stream(options.httpsBaseUrlProperties()).filter(StringUtils::isNotBlank).collect(Collectors.toList()).forEach(propertyName -> {
                String property = propertyName + "=" + String.format("https://localhost:%d", newServer.httpsPort());
                this.logger.info("Adding property '{}' with HTTPS base URL to Spring application context", (Object)property);
                TestPropertyValues.of((String[])new String[]{property}).applyTo(context.getEnvironment());
            });
            Arrays.stream(options.httpsPortProperties()).filter(StringUtils::isNotBlank).collect(Collectors.toList()).forEach(propertyName -> {
                String property = propertyName + "=" + newServer.httpsPort();
                this.logger.info("Adding property '{}' with HTTPS port to Spring application context", (Object)property);
                TestPropertyValues.of((String[])new String[]{property}).applyTo(context.getEnvironment());
            });
        }
        if (options.registerSpringBean()) {
            this.logger.info("Registering WireMockServer '" + options.name() + "' as a Spring Bean.");
            context.getBeanFactory().registerSingleton(options.name(), (Object)newServer);
        }
        return newServer;
    }

    private void configureMappings(ConfigureWireMock options, WireMockConfiguration serverOptions) {
        boolean isFilesUnderClasspathSupplied;
        boolean isFilesUnderDirectorySupplied = options.filesUnderDirectory().length != 0;
        boolean bl = isFilesUnderClasspathSupplied = !options.filesUnderClasspath().isEmpty();
        if (isFilesUnderDirectorySupplied) {
            Optional<String> foundFilesUnderDirectoryOpt = this.findFirstExistingDirectory(options.filesUnderDirectory());
            if (foundFilesUnderDirectoryOpt.isEmpty()) {
                throw new IllegalStateException("Cannot find configured mappings directory " + String.valueOf(options.filesUnderDirectory()));
            }
            this.usingFilesUnderDirectory(serverOptions, foundFilesUnderDirectoryOpt.get());
        } else if (isFilesUnderClasspathSupplied) {
            this.usingFilesUnderClasspath(serverOptions, options.filesUnderClasspath());
        } else {
            Optional<String> fondFilesUnderDirOpt = this.findFirstExistingDirectory(ConfigureWireMock.DEFAULT_FILES_UNDER_DIRECTORY.toArray(new String[0]));
            fondFilesUnderDirOpt.ifPresent(s -> this.usingFilesUnderDirectory(serverOptions, (String)s));
            if (fondFilesUnderDirOpt.isEmpty()) {
                this.logger.info("No mocks found under directory");
            }
        }
    }

    private int getServerHttpPortProperty(ConfigurableEnvironment environment, ConfigureWireMock options) {
        if (!options.usePortFromPredefinedPropertyIfFound()) {
            return options.port();
        }
        return Arrays.stream(options.portProperties()).filter(StringUtils::isNotBlank).filter(propertyName -> environment.containsProperty(propertyName)).map(propertyName -> {
            int predefinedPropertyValue = Integer.parseInt(environment.getProperty(propertyName));
            this.logger.info("Found predefined port in property with name '{}' on port: {}", propertyName, (Object)predefinedPropertyValue);
            return predefinedPropertyValue;
        }).findFirst().orElse(options.port());
    }

    private int getServerHttpsPortProperty(ConfigurableEnvironment environment, ConfigureWireMock options) {
        if (!options.usePortFromPredefinedPropertyIfFound()) {
            return options.httpsPort();
        }
        return Arrays.stream(options.httpsPortProperties()).filter(StringUtils::isNotBlank).filter(propertyName -> environment.containsProperty(propertyName)).map(propertyName -> {
            int predefinedPropertyValue = Integer.parseInt(environment.getProperty(propertyName));
            this.logger.info("Found predefined https port in property with name '{}' on port: {}", propertyName, (Object)predefinedPropertyValue);
            return predefinedPropertyValue;
        }).findFirst().orElse(options.httpsPort());
    }

    private void usingFilesUnderClasspath(WireMockConfiguration serverOptions, String resource) {
        this.logger.info("Serving WireMock mappings from classpath resource: " + resource);
        serverOptions.usingFilesUnderClasspath(resource);
    }

    private void usingFilesUnderDirectory(WireMockConfiguration serverOptions, String dir) {
        this.logger.info("Serving WireMock mappings from directory: " + dir);
        serverOptions.usingFilesUnderDirectory(dir);
    }

    private Optional<String> findFirstExistingDirectory(String ... filesUnderDirectory) {
        List<String> alternatives = Stream.of(filesUnderDirectory).filter(it -> {
            File name = Path.of(it, new String[0]).toFile();
            boolean exists = Path.of(it, "mappings").toFile().exists() || Path.of(it, "__files").toFile().exists();
            this.logger.info("Looking for mocks in directory " + String.valueOf(name) + "... " + (exists ? "found" : ""));
            return exists;
        }).toList();
        String alternativesString = alternatives.stream().collect(Collectors.joining(", "));
        this.logger.debug("Found " + alternativesString + " in " + Path.of("", new String[0]).toFile().getAbsolutePath());
        Optional<String> firstMatch = alternatives.stream().findFirst();
        if (firstMatch.isPresent()) {
            this.logger.info("Using mocks from " + firstMatch.get());
        }
        return firstMatch;
    }

    @SuppressFBWarnings
    private void applyCustomizers(ConfigureWireMock options, WireMockConfiguration serverOptions) {
        for (Class<? extends WireMockConfigurationCustomizer> customizer : options.configurationCustomizers()) {
            try {
                ((WireMockConfigurationCustomizer)ReflectionUtils.newInstance(customizer, (Object[])new Object[0])).customize(serverOptions, options);
            }
            catch (Exception e) {
                if (e instanceof NoSuchMethodException) {
                    this.logger.error("Customizer {} must have a no-arg constructor", customizer, (Object)e);
                }
                throw e;
            }
        }
    }
}

