/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import wiremock.org.eclipse.jetty.util.HostPort;
import wiremock.org.eclipse.jetty.util.StringUtil;
import wiremock.org.eclipse.jetty.util.TypeUtil;
import wiremock.org.eclipse.jetty.util.Utf8Appendable;
import wiremock.org.eclipse.jetty.util.Utf8StringBuilder;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public final class URIUtil {
    private static final Logger LOG = LoggerFactory.getLogger(URIUtil.class);
    public static final String SLASH = "/";
    public static final String HTTP = "http";
    public static final String HTTPS = "https";
    private static final String UNRESERVED = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-._~";
    private static final String SUBDELIMS = "!$&'()*+,;=";
    private static final String REGNAME = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-._~!$&'()*+,;=";
    private static final boolean[] REGNAME_ALLOWED = new boolean[128];
    public static final Charset __CHARSET;

    private URIUtil() {
    }

    public static String encodePath(String path) {
        if (path == null || path.length() == 0) {
            return path;
        }
        StringBuilder buf = URIUtil.encodePath(null, path, 0);
        return buf == null ? path : buf.toString();
    }

    public static StringBuilder encodePath(StringBuilder buf, String path) {
        return URIUtil.encodePath(buf, path, 0);
    }

    private static StringBuilder encodePath(StringBuilder buf, String path, int offset) {
        int i2;
        byte[] bytes = null;
        if (buf == null) {
            block41: for (int i22 = offset; i22 < path.length(); ++i22) {
                char c = path.charAt(i22);
                switch (c) {
                    case ' ': 
                    case '\"': 
                    case '#': 
                    case '%': 
                    case '\'': 
                    case ';': 
                    case '<': 
                    case '>': 
                    case '?': 
                    case '[': 
                    case '\\': 
                    case ']': 
                    case '^': 
                    case '`': 
                    case '{': 
                    case '|': 
                    case '}': {
                        buf = new StringBuilder(path.length() * 2);
                        break block41;
                    }
                    default: {
                        if (c >= ' ' && c < '\u007f') continue block41;
                        bytes = path.getBytes(__CHARSET);
                        buf = new StringBuilder(path.length() * 2);
                        break block41;
                    }
                }
            }
            if (buf == null) {
                return null;
            }
        }
        block42: for (i2 = offset; i2 < path.length(); ++i2) {
            char c = path.charAt(i2);
            switch (c) {
                case '%': {
                    buf.append("%25");
                    continue block42;
                }
                case '?': {
                    buf.append("%3F");
                    continue block42;
                }
                case ';': {
                    buf.append("%3B");
                    continue block42;
                }
                case '#': {
                    buf.append("%23");
                    continue block42;
                }
                case '\"': {
                    buf.append("%22");
                    continue block42;
                }
                case '\'': {
                    buf.append("%27");
                    continue block42;
                }
                case '<': {
                    buf.append("%3C");
                    continue block42;
                }
                case '>': {
                    buf.append("%3E");
                    continue block42;
                }
                case ' ': {
                    buf.append("%20");
                    continue block42;
                }
                case '[': {
                    buf.append("%5B");
                    continue block42;
                }
                case '\\': {
                    buf.append("%5C");
                    continue block42;
                }
                case ']': {
                    buf.append("%5D");
                    continue block42;
                }
                case '^': {
                    buf.append("%5E");
                    continue block42;
                }
                case '`': {
                    buf.append("%60");
                    continue block42;
                }
                case '{': {
                    buf.append("%7B");
                    continue block42;
                }
                case '|': {
                    buf.append("%7C");
                    continue block42;
                }
                case '}': {
                    buf.append("%7D");
                    continue block42;
                }
                default: {
                    if (c < ' ' || c >= '\u007f') {
                        bytes = path.getBytes(__CHARSET);
                        break block42;
                    }
                    buf.append(c);
                }
            }
        }
        if (bytes != null) {
            while (i2 < bytes.length) {
                void var5_7 = bytes[i2];
                switch (var5_7) {
                    case 37: {
                        buf.append("%25");
                        break;
                    }
                    case 63: {
                        buf.append("%3F");
                        break;
                    }
                    case 59: {
                        buf.append("%3B");
                        break;
                    }
                    case 35: {
                        buf.append("%23");
                        break;
                    }
                    case 34: {
                        buf.append("%22");
                        break;
                    }
                    case 39: {
                        buf.append("%27");
                        break;
                    }
                    case 60: {
                        buf.append("%3C");
                        break;
                    }
                    case 62: {
                        buf.append("%3E");
                        break;
                    }
                    case 32: {
                        buf.append("%20");
                        break;
                    }
                    case 91: {
                        buf.append("%5B");
                        break;
                    }
                    case 92: {
                        buf.append("%5C");
                        break;
                    }
                    case 93: {
                        buf.append("%5D");
                        break;
                    }
                    case 94: {
                        buf.append("%5E");
                        break;
                    }
                    case 96: {
                        buf.append("%60");
                        break;
                    }
                    case 123: {
                        buf.append("%7B");
                        break;
                    }
                    case 124: {
                        buf.append("%7C");
                        break;
                    }
                    case 125: {
                        buf.append("%7D");
                        break;
                    }
                    default: {
                        if (var5_7 < 32 || var5_7 >= 127) {
                            buf.append('%');
                            TypeUtil.toHex((byte)var5_7, (Appendable)buf);
                            break;
                        }
                        buf.append((char)var5_7);
                    }
                }
                ++i2;
            }
        }
        return buf;
    }

    public static String encodeSpaces(String str) {
        return StringUtil.replace(str, " ", "%20");
    }

    public static String encodeSpecific(String str, String charsToEncode) {
        if (str == null || str.length() == 0) {
            return null;
        }
        if (charsToEncode == null || charsToEncode.length() == 0) {
            return str;
        }
        char[] find = charsToEncode.toCharArray();
        int len = str.length();
        StringBuilder ret = new StringBuilder((int)((double)len * 0.2));
        for (int i2 = 0; i2 < len; ++i2) {
            char c = str.charAt(i2);
            boolean escaped = false;
            for (char f : find) {
                if (c != f) continue;
                escaped = true;
                ret.append('%');
                int d = 0xF & (0xF0 & c) >> 4;
                ret.append((char)((d > 9 ? 55 : 48) + d));
                d = 0xF & c;
                ret.append((char)((d > 9 ? 55 : 48) + d));
                break;
            }
            if (escaped) continue;
            ret.append(c);
        }
        return ret.toString();
    }

    public static String decodeSpecific(String str, String charsToDecode) {
        if (str == null || str.length() == 0) {
            return null;
        }
        if (charsToDecode == null || charsToDecode.length() == 0) {
            return str;
        }
        int idx = str.indexOf(37);
        if (idx == -1) {
            return str;
        }
        char[] find = charsToDecode.toCharArray();
        int len = str.length();
        Utf8StringBuilder ret = new Utf8StringBuilder(len);
        ret.append(str, 0, idx);
        block3: for (int i2 = idx; i2 < len; ++i2) {
            char c = str.charAt(i2);
            switch (c) {
                case '%': {
                    if (i2 + 2 < len) {
                        char u = str.charAt(i2 + 1);
                        char l = str.charAt(i2 + 2);
                        char result = (char)(0xFF & TypeUtil.convertHexDigit(u) * 16 + TypeUtil.convertHexDigit(l));
                        boolean decoded = false;
                        for (char f : find) {
                            if (f != result) continue;
                            ret.append(result);
                            decoded = true;
                            break;
                        }
                        if (decoded) {
                            i2 += 2;
                            continue block3;
                        }
                        ret.append(c);
                        continue block3;
                    }
                    throw new IllegalArgumentException("Bad URI % encoding");
                }
                default: {
                    ret.append(c);
                }
            }
        }
        return ret.toString();
    }

    public static StringBuilder encodeString(StringBuilder buf, String path, String encode) {
        char c;
        int i2;
        if (buf == null) {
            for (i2 = 0; i2 < path.length(); ++i2) {
                c = path.charAt(i2);
                if (c != '%' && encode.indexOf(c) < 0) continue;
                buf = new StringBuilder(path.length() << 1);
                break;
            }
            if (buf == null) {
                return null;
            }
        }
        for (i2 = 0; i2 < path.length(); ++i2) {
            c = path.charAt(i2);
            if (c == '%' || encode.indexOf(c) >= 0) {
                buf.append('%');
                StringUtil.append(buf, (byte)(0xFF & c), 16);
                continue;
            }
            buf.append(c);
        }
        return buf;
    }

    public static String decodePath(String path) {
        return URIUtil.decodePath(path, 0, path.length());
    }

    public static String decodePath(String path, int offset, int length) {
        try {
            Utf8StringBuilder builder = null;
            int end = offset + length;
            block8: for (int i2 = offset; i2 < end; ++i2) {
                char c = path.charAt(i2);
                switch (c) {
                    case '%': {
                        if (builder == null) {
                            builder = new Utf8StringBuilder(path.length());
                            builder.append(path, offset, i2 - offset);
                        }
                        if (i2 + 2 < end) {
                            char u = path.charAt(i2 + 1);
                            if (u == 'u') {
                                builder.append((char)(0xFFFF & TypeUtil.parseInt(path, i2 + 2, 4, 16)));
                                i2 += 5;
                                continue block8;
                            }
                            builder.append((byte)(0xFF & TypeUtil.convertHexDigit(u) * 16 + TypeUtil.convertHexDigit(path.charAt(i2 + 2))));
                            i2 += 2;
                            continue block8;
                        }
                        throw new IllegalArgumentException("Bad URI % encoding");
                    }
                    case ';': {
                        if (builder == null) {
                            builder = new Utf8StringBuilder(path.length());
                            builder.append(path, offset, i2 - offset);
                        }
                        while (++i2 < end) {
                            if (path.charAt(i2) != '/') continue;
                            builder.append('/');
                            continue block8;
                        }
                        continue block8;
                    }
                    default: {
                        if (builder == null) continue block8;
                        builder.append(c);
                    }
                }
            }
            if (builder != null) {
                return builder.toString();
            }
            if (offset == 0 && length == path.length()) {
                return path;
            }
            return path.substring(offset, end);
        }
        catch (Utf8Appendable.NotUtf8Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} {}", (Object)path.substring(offset, offset + length), (Object)e.toString());
            }
            return URIUtil.decodeISO88591Path(path, offset, length);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("cannot decode URI", e);
        }
    }

    private static String decodeISO88591Path(String path, int offset, int length) {
        StringBuilder builder = null;
        int end = offset + length;
        block4: for (int i2 = offset; i2 < end; ++i2) {
            char c = path.charAt(i2);
            switch (c) {
                case '%': {
                    if (builder == null) {
                        builder = new StringBuilder(path.length());
                        builder.append(path, offset, i2 - offset);
                    }
                    if (i2 + 2 < end) {
                        char u = path.charAt(i2 + 1);
                        if (u == 'u') {
                            builder.append((char)(0xFFFF & TypeUtil.parseInt(path, i2 + 2, 4, 16)));
                            i2 += 5;
                            continue block4;
                        }
                        builder.append((char)(0xFF & TypeUtil.convertHexDigit(u) * 16 + TypeUtil.convertHexDigit(path.charAt(i2 + 2))));
                        i2 += 2;
                        continue block4;
                    }
                    throw new IllegalArgumentException();
                }
                case ';': {
                    if (builder == null) {
                        builder = new StringBuilder(path.length());
                        builder.append(path, offset, i2 - offset);
                    }
                    while (++i2 < end) {
                        if (path.charAt(i2) != '/') continue;
                        builder.append('/');
                        continue block4;
                    }
                    continue block4;
                }
                default: {
                    if (builder == null) continue block4;
                    builder.append(c);
                }
            }
        }
        if (builder != null) {
            return builder.toString();
        }
        if (offset == 0 && length == path.length()) {
            return path;
        }
        return path.substring(offset, end);
    }

    public static String addEncodedPaths(String p1, String p2) {
        if (p1 == null || p1.length() == 0) {
            if (p1 != null && p2 == null) {
                return p1;
            }
            return p2;
        }
        if (p2 == null || p2.length() == 0) {
            return p1;
        }
        int split = p1.indexOf(59);
        if (split < 0) {
            split = p1.indexOf(63);
        }
        if (split == 0) {
            return p2 + p1;
        }
        if (split < 0) {
            split = p1.length();
        }
        StringBuilder buf = new StringBuilder(p1.length() + p2.length() + 2);
        buf.append(p1);
        if (buf.charAt(split - 1) == '/') {
            if (p2.startsWith(SLASH)) {
                buf.deleteCharAt(split - 1);
                buf.insert(split - 1, p2);
            } else {
                buf.insert(split, p2);
            }
        } else if (p2.startsWith(SLASH)) {
            buf.insert(split, p2);
        } else {
            buf.insert(split, '/');
            buf.insert(split + 1, p2);
        }
        return buf.toString();
    }

    public static String addPaths(String p1, String p2) {
        if (p1 == null || p1.length() == 0) {
            if (p1 != null && p2 == null) {
                return p1;
            }
            return p2;
        }
        if (p2 == null || p2.length() == 0) {
            return p1;
        }
        boolean p1EndsWithSlash = p1.endsWith(SLASH);
        boolean p2StartsWithSlash = p2.startsWith(SLASH);
        if (p1EndsWithSlash && p2StartsWithSlash) {
            if (p2.length() == 1) {
                return p1;
            }
            if (p1.length() == 1) {
                return p2;
            }
        }
        StringBuilder buf = new StringBuilder(p1.length() + p2.length() + 2);
        buf.append(p1);
        if (p1.endsWith(SLASH)) {
            if (p2.startsWith(SLASH)) {
                buf.setLength(buf.length() - 1);
            }
        } else if (!p2.startsWith(SLASH)) {
            buf.append(SLASH);
        }
        buf.append(p2);
        return buf.toString();
    }

    public static String addPathQuery(String path, String query) {
        if (query == null) {
            return path;
        }
        if (path.indexOf(63) >= 0) {
            return path + "&" + query;
        }
        return path + "?" + query;
    }

    public static String getUriLastPathSegment(URI uri) {
        String ssp = uri.getSchemeSpecificPart();
        int idx = ssp.indexOf("!/");
        if (idx != -1) {
            ssp = ssp.substring(0, idx);
        }
        if (ssp.endsWith(SLASH)) {
            ssp = ssp.substring(0, ssp.length() - 1);
        }
        if ((idx = ssp.lastIndexOf(47)) != -1) {
            ssp = ssp.substring(idx + 1);
        }
        return ssp;
    }

    public static String parentPath(String p) {
        if (p == null || SLASH.equals(p)) {
            return null;
        }
        int slash = p.lastIndexOf(47, p.length() - 2);
        if (slash >= 0) {
            return p.substring(0, slash + 1);
        }
        return null;
    }

    public static String canonicalURI(String uri) {
        int i2;
        if (uri == null || uri.isEmpty()) {
            return uri;
        }
        boolean slash = true;
        int end = uri.length();
        block10: for (i2 = 0; i2 < end; ++i2) {
            char c = uri.charAt(i2);
            switch (c) {
                case '/': {
                    slash = true;
                    continue block10;
                }
                case '.': {
                    if (slash) break block10;
                    slash = false;
                    continue block10;
                }
                case '#': 
                case '?': {
                    return uri;
                }
                default: {
                    slash = false;
                }
            }
        }
        if (i2 == end) {
            return uri;
        }
        StringBuilder canonical = new StringBuilder(uri.length());
        canonical.append(uri, 0, i2);
        int dots = 1;
        ++i2;
        block11: while (i2 < end) {
            char c = uri.charAt(i2);
            switch (c) {
                case '/': {
                    if (URIUtil.doDotsSlash(canonical, dots)) {
                        return null;
                    }
                    slash = true;
                    dots = 0;
                    break;
                }
                case '#': 
                case '?': {
                    break block11;
                }
                case '.': {
                    if (dots > 0) {
                        ++dots;
                    } else if (slash) {
                        dots = 1;
                    } else {
                        canonical.append('.');
                    }
                    slash = false;
                    break;
                }
                default: {
                    while (dots-- > 0) {
                        canonical.append('.');
                    }
                    canonical.append(c);
                    dots = 0;
                    slash = false;
                }
            }
            ++i2;
        }
        if (URIUtil.doDots(canonical, dots)) {
            return null;
        }
        if (i2 < end) {
            canonical.append(uri, i2, end);
        }
        return canonical.toString();
    }

    @Deprecated
    public static String canonicalEncodedPath(String path) {
        return URIUtil.canonicalURI(path);
    }

    public static String canonicalPath(String path) {
        int i2;
        if (path == null || path.isEmpty()) {
            return path;
        }
        boolean slash = true;
        int end = path.length();
        block8: for (i2 = 0; i2 < end; ++i2) {
            char c = path.charAt(i2);
            switch (c) {
                case '/': {
                    slash = true;
                    continue block8;
                }
                case '.': {
                    if (slash) break block8;
                    slash = false;
                    continue block8;
                }
                default: {
                    slash = false;
                }
            }
        }
        if (i2 == end) {
            return path;
        }
        StringBuilder canonical = new StringBuilder(path.length());
        canonical.append(path, 0, i2);
        int dots = 1;
        ++i2;
        while (i2 < end) {
            char c = path.charAt(i2);
            switch (c) {
                case '/': {
                    if (URIUtil.doDotsSlash(canonical, dots)) {
                        return null;
                    }
                    slash = true;
                    dots = 0;
                    break;
                }
                case '.': {
                    if (dots > 0) {
                        ++dots;
                    } else if (slash) {
                        dots = 1;
                    } else {
                        canonical.append('.');
                    }
                    slash = false;
                    break;
                }
                default: {
                    while (dots-- > 0) {
                        canonical.append('.');
                    }
                    canonical.append(c);
                    dots = 0;
                    slash = false;
                }
            }
            ++i2;
        }
        if (URIUtil.doDots(canonical, dots)) {
            return null;
        }
        return canonical.toString();
    }

    private static boolean doDots(StringBuilder canonical, int dots) {
        switch (dots) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                if (canonical.length() < 2) {
                    return true;
                }
                canonical.setLength(canonical.length() - 1);
                canonical.setLength(canonical.lastIndexOf(SLASH) + 1);
                break;
            }
            default: {
                while (dots-- > 0) {
                    canonical.append('.');
                }
                break block0;
            }
        }
        return false;
    }

    private static boolean doDotsSlash(StringBuilder canonical, int dots) {
        switch (dots) {
            case 0: {
                canonical.append('/');
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (canonical.length() < 2) {
                    return true;
                }
                canonical.setLength(canonical.length() - 1);
                canonical.setLength(canonical.lastIndexOf(SLASH) + 1);
                break;
            }
            default: {
                while (dots-- > 0) {
                    canonical.append('.');
                }
                canonical.append('/');
            }
        }
        return false;
    }

    public static String compactPath(String path) {
        int i2;
        if (path == null || path.length() == 0) {
            return path;
        }
        int state = 0;
        int end = path.length();
        block8: for (i2 = 0; i2 < end; ++i2) {
            char c = path.charAt(i2);
            switch (c) {
                case '?': {
                    return path;
                }
                case '/': {
                    if (++state != 2) continue block8;
                    break block8;
                }
                default: {
                    state = 0;
                }
            }
        }
        if (state < 2) {
            return path;
        }
        StringBuilder buf = new StringBuilder(path.length());
        buf.append(path, 0, i2);
        block9: while (i2 < end) {
            char c = path.charAt(i2);
            switch (c) {
                case '?': {
                    buf.append(path, i2, end);
                    break block9;
                }
                case '/': {
                    if (state++ != 0) break;
                    buf.append(c);
                    break;
                }
                default: {
                    state = 0;
                    buf.append(c);
                }
            }
            ++i2;
        }
        return buf.toString();
    }

    public static boolean hasScheme(String uri) {
        for (int i2 = 0; i2 < uri.length(); ++i2) {
            char c = uri.charAt(i2);
            if (c == ':') {
                return true;
            }
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || i2 > 0 && (c >= '0' && c <= '9' || c == '.' || c == '+' || c == '-'))) break;
        }
        return false;
    }

    public static boolean isValidHostRegisteredName(String token) {
        if (token == null) {
            return true;
        }
        int length = token.length();
        for (int i2 = 0; i2 < length; ++i2) {
            char c = token.charAt(i2);
            if (c > '\u007f') {
                return false;
            }
            if (REGNAME_ALLOWED[c]) continue;
            if (c == '%') {
                if (StringUtil.isHex(token, i2 + 1, 2)) {
                    i2 += 2;
                    continue;
                }
                return false;
            }
            return false;
        }
        return true;
    }

    public static String newURI(String scheme, String server, int port, String path, String query) {
        StringBuilder builder = URIUtil.newURIBuilder(scheme, server, port);
        builder.append(path);
        if (query != null && query.length() > 0) {
            builder.append('?').append(query);
        }
        return builder.toString();
    }

    public static StringBuilder newURIBuilder(String scheme, String server, int port) {
        StringBuilder builder = new StringBuilder();
        URIUtil.appendSchemeHostPort(builder, scheme, server, port);
        return builder;
    }

    public static void appendSchemeHostPort(StringBuilder url, String scheme, String server, int port) {
        url.append(scheme).append("://").append(HostPort.normalizeHost(server));
        if (port > 0) {
            switch (scheme) {
                case "http": {
                    if (port == 80) break;
                    url.append(':').append(port);
                    break;
                }
                case "https": {
                    if (port == 443) break;
                    url.append(':').append(port);
                    break;
                }
                default: {
                    url.append(':').append(port);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendSchemeHostPort(StringBuffer url, String scheme, String server, int port) {
        StringBuffer stringBuffer = url;
        synchronized (stringBuffer) {
            url.append(scheme).append("://").append(HostPort.normalizeHost(server));
            if (port > 0) {
                switch (scheme) {
                    case "http": {
                        if (port == 80) break;
                        url.append(':').append(port);
                        break;
                    }
                    case "https": {
                        if (port == 443) break;
                        url.append(':').append(port);
                        break;
                    }
                    default: {
                        url.append(':').append(port);
                    }
                }
            }
        }
    }

    public static boolean equalsIgnoreEncodings(String uriA, String uriB) {
        int lenA = uriA.length();
        int lenB = uriB.length();
        int a = 0;
        int b = 0;
        while (a < lenA && b < lenB) {
            int ob;
            int cb;
            int oa;
            int ca;
            if ((ca = (oa = uriA.charAt(a++))) == 37) {
                ca = URIUtil.lenientPercentDecode(uriA, a);
                if (ca == -1) {
                    ca = 37;
                } else {
                    a += 2;
                }
            }
            if ((cb = (ob = uriB.charAt(b++))) == 37) {
                cb = URIUtil.lenientPercentDecode(uriB, b);
                if (cb == -1) {
                    cb = 37;
                } else {
                    b += 2;
                }
            }
            if (ca == 47 && oa != ob) {
                return false;
            }
            if (ca == cb) continue;
            return false;
        }
        return a == lenA && b == lenB;
    }

    private static int lenientPercentDecode(String str, int offset) {
        if (offset >= str.length()) {
            return -1;
        }
        if (StringUtil.isHex(str, offset, 2)) {
            return TypeUtil.parseInt(str, offset, 2, 16);
        }
        return -1;
    }

    public static boolean equalsIgnoreEncodings(URI uriA, URI uriB) {
        if (uriA.equals(uriB)) {
            return true;
        }
        if (uriA.getScheme() == null ? uriB.getScheme() != null : !uriA.getScheme().equalsIgnoreCase(uriB.getScheme())) {
            return false;
        }
        if ("jar".equalsIgnoreCase(uriA.getScheme())) {
            URI uriAssp = URI.create(uriA.getSchemeSpecificPart());
            URI uriBssp = URI.create(uriB.getSchemeSpecificPart());
            return URIUtil.equalsIgnoreEncodings(uriAssp, uriBssp);
        }
        if (uriA.getAuthority() == null ? uriB.getAuthority() != null : !uriA.getAuthority().equals(uriB.getAuthority())) {
            return false;
        }
        return URIUtil.equalsIgnoreEncodings(uriA.getPath(), uriB.getPath());
    }

    public static URI addPath(URI uri, String path) {
        String base = uri.toASCIIString();
        StringBuilder buf = new StringBuilder(base.length() + path.length() * 3);
        buf.append(base);
        if (buf.charAt(base.length() - 1) != '/') {
            buf.append('/');
        }
        int offset = path.charAt(0) == '/' ? 1 : 0;
        URIUtil.encodePath(buf, path, offset);
        return URI.create(buf.toString());
    }

    public static String addQueries(String query1, String query2) {
        if (StringUtil.isEmpty(query1)) {
            return query2;
        }
        if (StringUtil.isEmpty(query2)) {
            return query1;
        }
        return query1 + "&" + query2;
    }

    public static URI getJarSource(URI uri) {
        try {
            if (!"jar".equals(uri.getScheme())) {
                return uri;
            }
            String s2 = uri.getRawSchemeSpecificPart();
            int bangSlash = s2.indexOf("!/");
            if (bangSlash >= 0) {
                s2 = s2.substring(0, bangSlash);
            }
            return new URI(s2);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String getJarSource(String uri) {
        if (!uri.startsWith("jar:")) {
            return uri;
        }
        int bangSlash = uri.indexOf("!/");
        return bangSlash >= 0 ? uri.substring(4, bangSlash) : uri.substring(4);
    }

    static {
        Arrays.fill(REGNAME_ALLOWED, false);
        for (char c : REGNAME.toCharArray()) {
            URIUtil.REGNAME_ALLOWED[c] = true;
        }
        __CHARSET = StandardCharsets.UTF_8;
    }
}

