/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import wiremock.jakarta.servlet.ServletException;
import wiremock.jakarta.servlet.http.HttpServletRequest;
import wiremock.jakarta.servlet.http.HttpServletResponse;
import wiremock.org.eclipse.jetty.server.Handler;
import wiremock.org.eclipse.jetty.server.HandlerContainer;
import wiremock.org.eclipse.jetty.server.HttpChannelState;
import wiremock.org.eclipse.jetty.server.Request;
import wiremock.org.eclipse.jetty.server.handler.ContextHandler;
import wiremock.org.eclipse.jetty.server.handler.HandlerCollection;
import wiremock.org.eclipse.jetty.util.ArrayUtil;
import wiremock.org.eclipse.jetty.util.Callback;
import wiremock.org.eclipse.jetty.util.Index;
import wiremock.org.eclipse.jetty.util.annotation.ManagedObject;
import wiremock.org.eclipse.jetty.util.annotation.ManagedOperation;
import wiremock.org.eclipse.jetty.util.thread.SerializedExecutor;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

@ManagedObject(value="Context Handler Collection")
public class ContextHandlerCollection
extends HandlerCollection {
    private static final Logger LOG = LoggerFactory.getLogger(ContextHandlerCollection.class);
    private final SerializedExecutor _serializedExecutor = new SerializedExecutor();

    public ContextHandlerCollection() {
        super(true, new Handler[0]);
    }

    public ContextHandlerCollection(ContextHandler ... contexts) {
        super(true, new Handler[0]);
        this.setHandlers(contexts);
    }

    @ManagedOperation(value="Update the mapping of context path to context")
    public void mapContexts() {
        this._serializedExecutor.execute(() -> {
            HandlerCollection.Handlers handlers;
            while ((handlers = (HandlerCollection.Handlers)this._handlers.get()) != null && !this.updateHandlers(handlers, this.newHandlers(handlers.getHandlers()))) {
            }
        });
    }

    @Override
    protected HandlerCollection.Handlers newHandlers(Handler[] handlers) {
        if (handlers == null || handlers.length == 0) {
            return null;
        }
        HashMap<String, Branch[]> path2Branches = new HashMap<String, Branch[]>();
        for (Handler handler : handlers) {
            Branch branch = new Branch(handler);
            for (String contextPath : branch.getContextPaths()) {
                Branch[] branches = (Branch[])path2Branches.get(contextPath);
                path2Branches.put(contextPath, ArrayUtil.addToArray(branches, branch, Branch.class));
            }
        }
        for (Map.Entry entry : path2Branches.entrySet()) {
            Branch[] branches = (Branch[])entry.getValue();
            Branch[] sorted = new Branch[branches.length];
            int i2 = 0;
            for (Branch branch : branches) {
                if (!branch.hasVirtualHost()) continue;
                sorted[i2++] = branch;
            }
            for (Branch branch : branches) {
                if (branch.hasVirtualHost()) continue;
                sorted[i2++] = branch;
            }
            entry.setValue(sorted);
        }
        Mapping mapping = new Mapping(handlers, path2Branches);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}", (Object)mapping._pathBranches);
        }
        return mapping;
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request2, HttpServletResponse response) throws IOException, ServletException {
        ContextHandler context;
        Mapping mapping = (Mapping)this._handlers.get();
        if (mapping == null) {
            return;
        }
        Handler[] handlers = mapping.getHandlers();
        if (handlers == null || handlers.length == 0) {
            return;
        }
        if (handlers.length == 1) {
            handlers[0].handle(target, baseRequest, request2, response);
            return;
        }
        HttpChannelState async = baseRequest.getHttpChannelState();
        if (async.isAsync() && (context = async.getContextHandler()) != null) {
            Handler branch = mapping._contextBranches.get(context);
            if (branch == null) {
                context.handle(target, baseRequest, request2, response);
            } else {
                branch.handle(target, baseRequest, request2, response);
            }
            return;
        }
        if (target.startsWith("/")) {
            Map.Entry<String, Branch[]> branches;
            Index<Map.Entry<String, Branch[]>> pathBranches = mapping._pathBranches;
            if (pathBranches == null) {
                return;
            }
            int limit = target.length() - 1;
            while (limit >= 0 && (branches = pathBranches.getBest(target, 1, limit)) != null) {
                int l = branches.getKey().length();
                if (l == 1 || target.length() == l || target.charAt(l) == '/') {
                    for (Branch branch : branches.getValue()) {
                        branch.getHandler().handle(target, baseRequest, request2, response);
                        if (!baseRequest.isHandled()) continue;
                        return;
                    }
                }
                limit = l - 2;
            }
        } else {
            for (Handler handler : handlers) {
                handler.handle(target, baseRequest, request2, response);
                if (!baseRequest.isHandled()) continue;
                return;
            }
        }
    }

    public void deployHandler(final Handler handler, final Callback callback) {
        if (handler.getServer() != this.getServer()) {
            handler.setServer(this.getServer());
        }
        this._serializedExecutor.execute(new SerializedExecutor.ErrorHandlingTask(){

            @Override
            public void run() {
                ContextHandlerCollection.this.addHandler(handler);
                callback.succeeded();
            }

            @Override
            public void accept(Throwable throwable) {
                callback.failed(throwable);
            }
        });
    }

    public void undeployHandler(final Handler handler, final Callback callback) {
        this._serializedExecutor.execute(new SerializedExecutor.ErrorHandlingTask(){

            @Override
            public void run() {
                ContextHandlerCollection.this.removeHandler(handler);
                callback.succeeded();
            }

            @Override
            public void accept(Throwable throwable) {
                callback.failed(throwable);
            }
        });
    }

    private static final class Branch {
        private final Handler _handler;
        private final ContextHandler[] _contexts;

        Branch(Handler handler) {
            this._handler = handler;
            if (handler instanceof ContextHandler) {
                this._contexts = new ContextHandler[]{(ContextHandler)handler};
            } else if (handler instanceof HandlerContainer) {
                Handler[] contexts = ((HandlerContainer)((Object)handler)).getChildHandlersByClass(ContextHandler.class);
                this._contexts = new ContextHandler[contexts.length];
                System.arraycopy(contexts, 0, this._contexts, 0, contexts.length);
            } else {
                this._contexts = new ContextHandler[0];
            }
        }

        Set<String> getContextPaths() {
            HashSet<String> set = new HashSet<String>();
            for (ContextHandler context : this._contexts) {
                set.add(context.getContextPath());
            }
            return set;
        }

        boolean hasVirtualHost() {
            for (ContextHandler context : this._contexts) {
                if (context.getVirtualHosts() == null || context.getVirtualHosts().length <= 0) continue;
                return true;
            }
            return false;
        }

        ContextHandler[] getContextHandlers() {
            return this._contexts;
        }

        Handler getHandler() {
            return this._handler;
        }

        public String toString() {
            return String.format("{%s,%s}", this._handler, Arrays.asList(this._contexts));
        }
    }

    private static class Mapping
    extends HandlerCollection.Handlers {
        private final Map<ContextHandler, Handler> _contextBranches;
        private final Index<Map.Entry<String, Branch[]>> _pathBranches = new Index.Builder().caseSensitive(true).withAll(() -> {
            LinkedHashMap result = new LinkedHashMap();
            for (Map.Entry entry : path2Branches.entrySet()) {
                result.put(((String)entry.getKey()).substring(1), entry);
            }
            return result;
        }).build();

        private Mapping(Handler[] handlers, Map<String, Branch[]> path2Branches) {
            super(handlers);
            HashMap<ContextHandler, Handler> contextBranches = new HashMap<ContextHandler, Handler>();
            for (Branch[] branches : path2Branches.values()) {
                for (Branch branch : branches) {
                    for (ContextHandler context : branch.getContextHandlers()) {
                        contextBranches.put(context, branch.getHandler());
                    }
                }
            }
            this._contextBranches = Collections.unmodifiableMap(contextBranches);
        }
    }
}

