/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.server;

import wiremock.org.eclipse.jetty.http.HostPortHttpField;
import wiremock.org.eclipse.jetty.http.HttpFields;
import wiremock.org.eclipse.jetty.http.HttpHeader;
import wiremock.org.eclipse.jetty.http.HttpScheme;
import wiremock.org.eclipse.jetty.http.HttpURI;
import wiremock.org.eclipse.jetty.http.HttpVersion;
import wiremock.org.eclipse.jetty.server.Connector;
import wiremock.org.eclipse.jetty.server.HttpConfiguration;
import wiremock.org.eclipse.jetty.server.Request;

public class HostHeaderCustomizer
implements HttpConfiguration.Customizer {
    private final String serverName;
    private final int serverPort;

    public HostHeaderCustomizer() {
        this(null, 0);
    }

    public HostHeaderCustomizer(String serverName) {
        this(serverName, 0);
    }

    public HostHeaderCustomizer(String serverName, int serverPort) {
        this.serverName = serverName;
        this.serverPort = serverPort;
    }

    @Override
    public void customize(Connector connector, HttpConfiguration channelConfig, Request request2) {
        if (request2.getHttpVersion() != HttpVersion.HTTP_1_1 && !request2.getHttpFields().contains(HttpHeader.HOST)) {
            String host = this.serverName == null ? request2.getServerName() : this.serverName;
            int port = HttpScheme.normalizePort(request2.getScheme(), this.serverPort == 0 ? request2.getServerPort() : this.serverPort);
            if (this.serverName != null || this.serverPort > 0) {
                request2.setHttpURI(HttpURI.build(request2.getHttpURI()).authority(host, port));
            }
            HttpFields original = request2.getHttpFields();
            HttpFields.Mutable httpFields = HttpFields.build(original.size() + 1);
            httpFields.add(new HostPortHttpField(host, port));
            httpFields.add(request2.getHttpFields());
            request2.setHttpFields(httpFields);
        }
    }
}

