/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.client;

import java.util.List;
import wiremock.org.eclipse.jetty.client.HttpConversation;
import wiremock.org.eclipse.jetty.client.HttpRequest;
import wiremock.org.eclipse.jetty.client.HttpResponse;
import wiremock.org.eclipse.jetty.client.HttpResponseException;
import wiremock.org.eclipse.jetty.client.HttpUpgrader;
import wiremock.org.eclipse.jetty.client.ProtocolHandler;
import wiremock.org.eclipse.jetty.client.ResponseNotifier;
import wiremock.org.eclipse.jetty.client.api.Request;
import wiremock.org.eclipse.jetty.client.api.Response;
import wiremock.org.eclipse.jetty.client.api.Result;
import wiremock.org.eclipse.jetty.http.HttpField;
import wiremock.org.eclipse.jetty.http.HttpHeader;
import wiremock.org.eclipse.jetty.io.EndPoint;
import wiremock.org.eclipse.jetty.util.Callback;

public class UpgradeProtocolHandler
implements ProtocolHandler {
    private final List<String> protocols = List.of("websocket", "h2c");

    @Override
    public String getName() {
        return "upgrade";
    }

    @Override
    public boolean accept(Request request2, Response response) {
        boolean upgraded = 101 == response.getStatus();
        boolean accepted = false;
        if (upgraded) {
            accepted = this.acceptHeaders(request2, response);
        }
        return upgraded && accepted;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean acceptHeaders(Request request2, Response response) {
        HttpField requestUpgrade;
        HttpField responseUpgrade = response.getHeaders().getField(HttpHeader.UPGRADE);
        if (responseUpgrade != null) {
            if (this.protocols.stream().anyMatch(responseUpgrade::contains)) {
                return true;
            }
        }
        if ((requestUpgrade = request2.getHeaders().getField(HttpHeader.UPGRADE)) == null) return false;
        if (!this.protocols.stream().anyMatch(requestUpgrade::contains)) return false;
        return true;
    }

    @Override
    public Response.Listener getResponseListener() {
        return new Response.Listener.Adapter(){

            @Override
            public void onComplete(Result result) {
                HttpResponse response = (HttpResponse)result.getResponse();
                HttpRequest request2 = (HttpRequest)response.getRequest();
                if (result.isSucceeded()) {
                    try {
                        HttpConversation conversation = request2.getConversation();
                        HttpUpgrader upgrader = (HttpUpgrader)conversation.getAttribute(HttpUpgrader.class.getName());
                        if (upgrader == null) {
                            throw new HttpResponseException("101 response without " + HttpUpgrader.class.getSimpleName(), response);
                        }
                        EndPoint endPoint = (EndPoint)conversation.getAttribute(EndPoint.class.getName());
                        if (endPoint == null) {
                            throw new HttpResponseException("Upgrade without " + EndPoint.class.getSimpleName(), response);
                        }
                        upgrader.upgrade(response, endPoint, Callback.from(Callback.NOOP::succeeded, x -> UpgradeProtocolHandler.this.forwardFailureComplete(request2, null, response, (Throwable)x)));
                    }
                    catch (Throwable x2) {
                        UpgradeProtocolHandler.this.forwardFailureComplete(request2, null, response, x2);
                    }
                } else {
                    UpgradeProtocolHandler.this.forwardFailureComplete(request2, result.getRequestFailure(), response, result.getResponseFailure());
                }
            }
        };
    }

    private void forwardFailureComplete(HttpRequest request2, Throwable requestFailure, Response response, Throwable responseFailure) {
        HttpConversation conversation = request2.getConversation();
        conversation.updateResponseListeners(null);
        List<Response.ResponseListener> responseListeners = conversation.getResponseListeners();
        ResponseNotifier notifier = new ResponseNotifier();
        notifier.forwardFailure(responseListeners, response, responseFailure);
        notifier.notifyComplete(responseListeners, new Result(request2, requestFailure, response, responseFailure));
    }
}

