/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.custommonkey.xmlunit;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import wiremock.org.custommonkey.xmlunit.XMLConstants;
import wiremock.org.xmlunit.diff.XPathContext;
import wiremock.org.xmlunit.util.IterableNodeList;
import wiremock.org.xmlunit.util.Linqy;

public class XpathNodeTracker
implements XMLConstants {
    private XPathContext ctx;
    private final LinkedList<TrackingEntry> levels = new LinkedList();

    public XpathNodeTracker() {
        this.ctx = new XPathContext();
        this.newLevel();
    }

    public void reset() {
        this.ctx = new XPathContext();
        this.levels.clear();
        this.indent();
    }

    public void indent() {
        this.newLevel();
    }

    private void newLevel() {
        this.clearTrackedAttribute();
        this.levels.add(new TrackingEntry());
    }

    public void clearTrackedAttribute() {
        if (this.levels.size() > 0) {
            this.levels.getLast().clearTrackedAttribute();
        }
    }

    public void outdent() {
        if (this.levels.size() < 2) {
            this.reset();
        } else {
            this.levels.getLast().reset();
            this.levels.removeLast();
        }
    }

    public void visited(Node node) {
        switch (node.getNodeType()) {
            case 2: {
                this.visitedAttribute(XpathNodeTracker.getNodeName(node));
                break;
            }
            case 1: {
                this.visitedNode(node, XpathNodeTracker.getNodeName(node));
                break;
            }
            case 8: {
                this.visitedNode(node, "comment()");
                break;
            }
            case 7: {
                this.visitedNode(node, "processing-instruction()");
                break;
            }
            case 3: 
            case 4: {
                this.visitedNode(node, "text()");
                break;
            }
        }
    }

    protected void visitedNode(Node visited, String value) {
        this.levels.getLast().trackNode(visited, value);
    }

    protected void visitedAttribute(String visited) {
        this.levels.getLast().trackAttribute(new QName(visited));
    }

    public void preloadNodeList(NodeList nodeList) {
        this.preloadChildren(new IterableNodeList(nodeList));
    }

    public void preloadChildList(List nodeList) {
        Iterable<Node> nodes = Linqy.cast(nodeList);
        this.preloadChildren(nodes);
    }

    public String toXpathString() {
        return this.ctx.getXPath();
    }

    private static String getNodeName(Node n) {
        String nodeName = n.getLocalName();
        if (nodeName == null || nodeName.length() == 0) {
            nodeName = n.getNodeName();
        }
        return nodeName;
    }

    private void preloadChildren(Iterable<Node> nodeList) {
        this.levels.getLast().trackNodesAsWellAsValues(true);
        for (Node n : nodeList) {
            this.visited(n);
        }
        this.levels.getLast().trackNodesAsWellAsValues(false);
    }

    private final class TrackingEntry {
        private boolean atAttribute = false;
        private boolean atChild = false;
        private int nextIndex = 0;
        private Map<Node, Integer> nodeReferenceMap = null;
        private boolean trackNodeReferences = false;

        private TrackingEntry() {
        }

        private void trackNode(Node visited, final String value) {
            if (this.trackNodeReferences && visited != null) {
                this.nodeReferenceMap.put(visited, this.nextIndex++);
            }
            int currentIndex = this.nodeReferenceMap == null || visited == null || !this.nodeReferenceMap.containsKey(visited) ? this.nextIndex++ : this.nodeReferenceMap.get(visited);
            this.reset();
            if (this.trackNodeReferences || this.nodeReferenceMap == null) {
                XPathContext.NodeInfo i2 = visited != null ? new XPathContext.DOMNodeInfo(visited) : new XPathContext.NodeInfo(){

                    @Override
                    public short getType() {
                        return 1;
                    }

                    @Override
                    public QName getName() {
                        return new QName(value);
                    }
                };
                XpathNodeTracker.this.ctx.appendChildren(Linqy.singleton(i2));
            }
            if (!this.trackNodeReferences) {
                XpathNodeTracker.this.ctx.navigateToChild(currentIndex);
                this.atChild = true;
            }
        }

        private void trackAttribute(QName visited) {
            if (this.atAttribute) {
                XpathNodeTracker.this.ctx.navigateToParent();
            }
            XpathNodeTracker.this.ctx.addAttributes(Linqy.singleton(visited));
            XpathNodeTracker.this.ctx.navigateToAttribute(visited);
            this.atAttribute = true;
        }

        void clearTrackedAttribute() {
            if (this.atAttribute) {
                XpathNodeTracker.this.ctx.navigateToParent();
                this.atAttribute = false;
            }
        }

        private void reset() {
            this.clearTrackedAttribute();
            if (this.atChild) {
                XpathNodeTracker.this.ctx.navigateToParent();
                this.atChild = false;
            }
        }

        void trackNodesAsWellAsValues(boolean yesNo) {
            this.trackNodeReferences = yesNo;
            if (yesNo) {
                this.nodeReferenceMap = new HashMap<Node, Integer>();
            }
        }
    }
}

