/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.apache.hc.core5.http.io.support;

import java.io.IOException;
import wiremock.org.apache.hc.core5.annotation.Contract;
import wiremock.org.apache.hc.core5.annotation.ThreadingBehavior;
import wiremock.org.apache.hc.core5.http.ClassicHttpRequest;
import wiremock.org.apache.hc.core5.http.ClassicHttpResponse;
import wiremock.org.apache.hc.core5.http.HttpException;
import wiremock.org.apache.hc.core5.http.HttpRequestMapper;
import wiremock.org.apache.hc.core5.http.HttpResponseFactory;
import wiremock.org.apache.hc.core5.http.impl.io.DefaultClassicHttpResponseFactory;
import wiremock.org.apache.hc.core5.http.io.HttpFilterChain;
import wiremock.org.apache.hc.core5.http.io.HttpFilterHandler;
import wiremock.org.apache.hc.core5.http.io.HttpRequestHandler;
import wiremock.org.apache.hc.core5.http.protocol.HttpContext;
import wiremock.org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.STATELESS)
public final class TerminalServerFilter
implements HttpFilterHandler {
    private final HttpRequestMapper<HttpRequestHandler> handlerMapper;
    private final HttpResponseFactory<ClassicHttpResponse> responseFactory;

    public TerminalServerFilter(HttpRequestMapper<HttpRequestHandler> handlerMapper, HttpResponseFactory<ClassicHttpResponse> responseFactory) {
        this.handlerMapper = Args.notNull(handlerMapper, "Handler mapper");
        this.responseFactory = responseFactory != null ? responseFactory : DefaultClassicHttpResponseFactory.INSTANCE;
    }

    @Override
    public void handle(ClassicHttpRequest request2, HttpFilterChain.ResponseTrigger responseTrigger, HttpContext context, HttpFilterChain chain) throws HttpException, IOException {
        ClassicHttpResponse response = this.responseFactory.newHttpResponse(200);
        HttpRequestHandler handler = this.handlerMapper.resolve(request2, context);
        if (handler != null) {
            handler.handle(request2, response, context);
        } else {
            response.setCode(501);
        }
        responseTrigger.submitResponse(response);
    }
}

