/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.apache.hc.client5.http.impl.classic;

import java.io.IOException;
import wiremock.org.apache.hc.client5.http.ClientProtocolException;
import wiremock.org.apache.hc.client5.http.classic.HttpClient;
import wiremock.org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import wiremock.org.apache.hc.client5.http.routing.RoutingSupport;
import wiremock.org.apache.hc.core5.annotation.Contract;
import wiremock.org.apache.hc.core5.annotation.ThreadingBehavior;
import wiremock.org.apache.hc.core5.http.ClassicHttpRequest;
import wiremock.org.apache.hc.core5.http.HttpEntity;
import wiremock.org.apache.hc.core5.http.HttpException;
import wiremock.org.apache.hc.core5.http.HttpHost;
import wiremock.org.apache.hc.core5.http.io.HttpClientResponseHandler;
import wiremock.org.apache.hc.core5.http.io.entity.EntityUtils;
import wiremock.org.apache.hc.core5.http.protocol.HttpContext;
import wiremock.org.apache.hc.core5.io.ModalCloseable;
import wiremock.org.apache.hc.core5.util.Args;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.SAFE)
public abstract class CloseableHttpClient
implements HttpClient,
ModalCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(CloseableHttpClient.class);

    protected abstract CloseableHttpResponse doExecute(HttpHost var1, ClassicHttpRequest var2, HttpContext var3) throws IOException;

    private static HttpHost determineTarget(ClassicHttpRequest request2) throws ClientProtocolException {
        try {
            return RoutingSupport.determineHost(request2);
        }
        catch (HttpException ex) {
            throw new ClientProtocolException(ex);
        }
    }

    @Override
    @Deprecated
    public CloseableHttpResponse execute(HttpHost target, ClassicHttpRequest request2, HttpContext context) throws IOException {
        return this.doExecute(target, request2, context);
    }

    @Override
    @Deprecated
    public CloseableHttpResponse execute(ClassicHttpRequest request2, HttpContext context) throws IOException {
        Args.notNull(request2, "HTTP request");
        return this.doExecute(CloseableHttpClient.determineTarget(request2), request2, context);
    }

    @Override
    @Deprecated
    public CloseableHttpResponse execute(ClassicHttpRequest request2) throws IOException {
        return this.doExecute(CloseableHttpClient.determineTarget(request2), request2, null);
    }

    @Override
    @Deprecated
    public CloseableHttpResponse execute(HttpHost target, ClassicHttpRequest request2) throws IOException {
        return this.doExecute(target, request2, null);
    }

    @Override
    public <T> T execute(ClassicHttpRequest request2, HttpClientResponseHandler<? extends T> responseHandler) throws IOException {
        return this.execute(request2, null, responseHandler);
    }

    @Override
    public <T> T execute(ClassicHttpRequest request2, HttpContext context, HttpClientResponseHandler<? extends T> responseHandler) throws IOException {
        HttpHost target = CloseableHttpClient.determineTarget(request2);
        return this.execute(target, request2, context, responseHandler);
    }

    @Override
    public <T> T execute(HttpHost target, ClassicHttpRequest request2, HttpClientResponseHandler<? extends T> responseHandler) throws IOException {
        return this.execute(target, request2, null, responseHandler);
    }

    @Override
    public <T> T execute(HttpHost target, ClassicHttpRequest request2, HttpContext context, HttpClientResponseHandler<? extends T> responseHandler) throws IOException {
        Args.notNull(responseHandler, "Response handler");
        Throwable throwable = null;
        try (CloseableHttpResponse response = this.doExecute(target, request2, context);){
            T result = responseHandler.handleResponse(response);
            HttpEntity entity = response.getEntity();
            EntityUtils.consume(entity);
            T t2 = result;
            return t2;
        }
        catch (HttpException t3) {
            try {
                HttpEntity entity = response.getEntity();
                try {
                    EntityUtils.consume(entity);
                }
                catch (Exception t2) {
                    LOG.warn("Error consuming content after an exception.", t2);
                }
                throw new ClientProtocolException(t3);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }
}

