/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema;

import java.util.function.Consumer;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.networknt.schema.ExecutionContext;
import wiremock.com.networknt.schema.JsonNodePath;
import wiremock.com.networknt.schema.JsonValidator;
import wiremock.com.networknt.schema.Keyword;
import wiremock.com.networknt.schema.SchemaLocation;
import wiremock.com.networknt.schema.annotation.JsonNodeAnnotation;

public abstract class AbstractJsonValidator
implements JsonValidator {
    private final SchemaLocation schemaLocation;
    private final JsonNode schemaNode;
    private final JsonNodePath evaluationPath;
    private final String keyword;

    public AbstractJsonValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, Keyword keyword, JsonNode schemaNode) {
        this.schemaLocation = schemaLocation;
        this.evaluationPath = evaluationPath;
        this.keyword = keyword.getValue();
        this.schemaNode = schemaNode;
    }

    @Override
    public SchemaLocation getSchemaLocation() {
        return this.schemaLocation;
    }

    @Override
    public JsonNodePath getEvaluationPath() {
        return this.evaluationPath;
    }

    @Override
    public String getKeyword() {
        return this.keyword;
    }

    public JsonNode getSchemaNode() {
        return this.schemaNode;
    }

    public String toString() {
        return this.getEvaluationPath().getName(-1);
    }

    protected boolean collectAnnotations(ExecutionContext executionContext) {
        return this.collectAnnotations(executionContext, this.getKeyword());
    }

    protected boolean collectAnnotations(ExecutionContext executionContext, String keyword) {
        return executionContext.getExecutionConfig().isAnnotationCollectionEnabled() && executionContext.getExecutionConfig().getAnnotationCollectionFilter().test(keyword);
    }

    protected void putAnnotation(ExecutionContext executionContext, Consumer<JsonNodeAnnotation.Builder> customizer2) {
        JsonNodeAnnotation.Builder builder = JsonNodeAnnotation.builder().evaluationPath(this.evaluationPath).schemaLocation(this.schemaLocation).keyword(this.getKeyword());
        customizer2.accept(builder);
        executionContext.getAnnotations().put(builder.build());
    }
}

