/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.github.jknack.handlebars.internal.antlr.tree.xpath;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import wiremock.com.github.jknack.handlebars.internal.antlr.ANTLRInputStream;
import wiremock.com.github.jknack.handlebars.internal.antlr.CommonTokenStream;
import wiremock.com.github.jknack.handlebars.internal.antlr.LexerNoViableAltException;
import wiremock.com.github.jknack.handlebars.internal.antlr.Parser;
import wiremock.com.github.jknack.handlebars.internal.antlr.ParserRuleContext;
import wiremock.com.github.jknack.handlebars.internal.antlr.Token;
import wiremock.com.github.jknack.handlebars.internal.antlr.tree.ParseTree;
import wiremock.com.github.jknack.handlebars.internal.antlr.tree.xpath.XPathElement;
import wiremock.com.github.jknack.handlebars.internal.antlr.tree.xpath.XPathLexer;
import wiremock.com.github.jknack.handlebars.internal.antlr.tree.xpath.XPathLexerErrorListener;
import wiremock.com.github.jknack.handlebars.internal.antlr.tree.xpath.XPathRuleAnywhereElement;
import wiremock.com.github.jknack.handlebars.internal.antlr.tree.xpath.XPathRuleElement;
import wiremock.com.github.jknack.handlebars.internal.antlr.tree.xpath.XPathTokenAnywhereElement;
import wiremock.com.github.jknack.handlebars.internal.antlr.tree.xpath.XPathTokenElement;
import wiremock.com.github.jknack.handlebars.internal.antlr.tree.xpath.XPathWildcardAnywhereElement;
import wiremock.com.github.jknack.handlebars.internal.antlr.tree.xpath.XPathWildcardElement;

public class XPath {
    public static final String WILDCARD = "*";
    public static final String NOT = "!";
    protected String path;
    protected XPathElement[] elements;
    protected Parser parser;

    public XPath(Parser parser, String path) {
        this.parser = parser;
        this.path = path;
        this.elements = this.split(path);
    }

    public XPathElement[] split(String path) {
        ANTLRInputStream in;
        try {
            in = new ANTLRInputStream(new StringReader(path));
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Could not read path: " + path, ioe);
        }
        XPathLexer lexer = new XPathLexer(in){

            @Override
            public void recover(LexerNoViableAltException e) {
                throw e;
            }
        };
        lexer.removeErrorListeners();
        lexer.addErrorListener(new XPathLexerErrorListener());
        CommonTokenStream tokenStream = new CommonTokenStream(lexer);
        try {
            tokenStream.fill();
        }
        catch (LexerNoViableAltException e) {
            int pos = lexer.getCharPositionInLine();
            String msg = "Invalid tokens or characters at index " + pos + " in path '" + path + "'";
            throw new IllegalArgumentException(msg, e);
        }
        List<Token> tokens = tokenStream.getTokens();
        ArrayList<XPathElement> elements = new ArrayList<XPathElement>();
        int n = tokens.size();
        int i2 = 0;
        block9: while (i2 < n) {
            Token el = tokens.get(i2);
            Token next = null;
            switch (el.getType()) {
                case 3: 
                case 4: {
                    boolean invert;
                    boolean anywhere = el.getType() == 3;
                    next = tokens.get(++i2);
                    boolean bl = invert = next.getType() == 6;
                    if (invert) {
                        next = tokens.get(++i2);
                    }
                    XPathElement pathElement = this.getXPathElement(next, anywhere);
                    pathElement.invert = invert;
                    elements.add(pathElement);
                    ++i2;
                    break;
                }
                case 1: 
                case 2: 
                case 5: {
                    elements.add(this.getXPathElement(el, false));
                    ++i2;
                    break;
                }
                case -1: {
                    break block9;
                }
                default: {
                    throw new IllegalArgumentException("Unknowth path element " + el);
                }
            }
        }
        return elements.toArray(new XPathElement[0]);
    }

    protected XPathElement getXPathElement(Token wordToken, boolean anywhere) {
        if (wordToken.getType() == -1) {
            throw new IllegalArgumentException("Missing path element at end of path");
        }
        String word = wordToken.getText();
        int ttype = this.parser.getTokenType(word);
        int ruleIndex = this.parser.getRuleIndex(word);
        switch (wordToken.getType()) {
            case 5: {
                return anywhere ? new XPathWildcardAnywhereElement() : new XPathWildcardElement();
            }
            case 1: 
            case 8: {
                if (ttype == 0) {
                    throw new IllegalArgumentException(word + " at index " + wordToken.getStartIndex() + " isn't a valid token name");
                }
                return anywhere ? new XPathTokenAnywhereElement(word, ttype) : new XPathTokenElement(word, ttype);
            }
        }
        if (ruleIndex == -1) {
            throw new IllegalArgumentException(word + " at index " + wordToken.getStartIndex() + " isn't a valid rule name");
        }
        return anywhere ? new XPathRuleAnywhereElement(word, ruleIndex) : new XPathRuleElement(word, ruleIndex);
    }

    public static Collection<ParseTree> findAll(ParseTree tree, String xpath, Parser parser) {
        XPath p = new XPath(parser, xpath);
        return p.evaluate(tree);
    }

    public Collection<ParseTree> evaluate(ParseTree t2) {
        ParserRuleContext dummyRoot = new ParserRuleContext();
        dummyRoot.children = Collections.singletonList(t2);
        Set<ParseTree> work = Collections.singleton(dummyRoot);
        for (int i2 = 0; i2 < this.elements.length; ++i2) {
            LinkedHashSet<ParseTree> next = new LinkedHashSet<ParseTree>();
            for (ParseTree node : work) {
                if (node.getChildCount() <= 0) continue;
                Collection<ParseTree> matching = this.elements[i2].evaluate(node);
                next.addAll(matching);
            }
            work = next;
        }
        return work;
    }
}

