/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.github.jknack.handlebars.helper;

import java.io.IOException;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import wiremock.com.github.jknack.handlebars.Handlebars;
import wiremock.com.github.jknack.handlebars.Helper;
import wiremock.com.github.jknack.handlebars.Options;
import wiremock.com.github.jknack.handlebars.helper.NumberStyle;
import wiremock.com.github.jknack.handlebars.internal.lang3.LocaleUtils;
import wiremock.com.github.jknack.handlebars.internal.lang3.StringUtils;
import wiremock.com.github.jknack.handlebars.internal.lang3.Validate;
import wiremock.com.github.jknack.handlebars.internal.text.WordUtils;

public enum StringHelpers implements Helper<Object>
{
    capitalizeFirst{

        @Override
        protected CharSequence safeApply(Object value, Options options2) {
            return StringUtils.capitalize(value.toString());
        }
    }
    ,
    center{

        @Override
        protected CharSequence safeApply(Object value, Options options2) {
            Integer size = (Integer)options2.hash("size");
            Validate.notNull(size, "found 'null', expected 'size'", new Object[0]);
            String pad = (String)options2.hash("pad", " ");
            return StringUtils.center(value.toString(), (int)size, pad);
        }
    }
    ,
    cut{

        @Override
        public Object apply(Object context, Options options2) throws IOException {
            return this.safeApply(context, options2);
        }

        @Override
        protected CharSequence safeApply(Object value, Options options2) {
            if (options2.isFalsy(value)) {
                return "";
            }
            String strip = options2.param(0, " ");
            return value.toString().replace(strip, "");
        }
    }
    ,
    defaultIfEmpty{

        @Override
        public Object apply(Object value, Options options2) throws IOException {
            if (Handlebars.Utils.isEmpty(value)) {
                return options2.param(0, "");
            }
            return String.valueOf(value);
        }

        @Override
        protected CharSequence safeApply(Object context, Options options2) {
            return null;
        }
    }
    ,
    join{

        @Override
        public Object apply(Object context, Options options2) {
            if (options2.isFalsy(context)) {
                return "";
            }
            return this.safeApply(context, options2);
        }

        @Override
        protected CharSequence safeApply(Object context, Options options2) {
            int separatorIdx = options2.params.length - 1;
            Object separator = options2.param(separatorIdx, null);
            Validate.notNull(separator, "found 'null', expected 'separator' at param[%s]", separatorIdx);
            Validate.isTrue(separator instanceof String, "found '%s', expected 'separator' at param[%s]", separator, separatorIdx);
            String prefix = (String)options2.hash("prefix", "");
            String suffix = (String)options2.hash("suffix", "");
            if (context instanceof Iterable) {
                return prefix + StringUtils.join((Iterable)context, (String)separator) + suffix;
            }
            if (context instanceof Iterator) {
                return prefix + StringUtils.join((Iterator)context, (String)separator) + suffix;
            }
            if (context.getClass().isArray()) {
                return prefix + StringUtils.join((Object[])context, (String)separator) + suffix;
            }
            Object[] values = new Object[options2.params.length];
            System.arraycopy(options2.params, 0, values, 1, separatorIdx);
            values[0] = context;
            return prefix + StringUtils.join(values, (String)separator) + suffix;
        }
    }
    ,
    ljust{

        @Override
        protected CharSequence safeApply(Object value, Options options2) {
            Integer size = (Integer)options2.hash("size");
            Validate.notNull(size, "found 'null', expected 'size'", new Object[0]);
            String pad = (String)options2.hash("pad", " ");
            return StringUtils.rightPad(value.toString(), (int)size, pad);
        }
    }
    ,
    rjust{

        @Override
        protected CharSequence safeApply(Object value, Options options2) {
            Integer size = (Integer)options2.hash("size");
            Validate.notNull(size, "found 'null', expected 'size'", new Object[0]);
            String pad = (String)options2.hash("pad", " ");
            return StringUtils.leftPad(value.toString(), (int)size, pad);
        }
    }
    ,
    substring{

        @Override
        protected CharSequence safeApply(Object value, Options options2) {
            Validate.validIndex(options2.params, 0, "Required start offset: ", new Object[0]);
            String str = value.toString();
            Integer start = (Integer)options2.param(0);
            Integer end = options2.param(1, str.length());
            return str.subSequence(start, end);
        }
    }
    ,
    lower{

        @Override
        protected CharSequence safeApply(Object value, Options options2) {
            return value.toString().toLowerCase();
        }
    }
    ,
    upper{

        @Override
        protected CharSequence safeApply(Object value, Options options2) {
            return value.toString().toUpperCase();
        }
    }
    ,
    slugify{

        @Override
        protected CharSequence safeApply(Object context, Options options2) {
            String value = StringUtils.strip(context.toString());
            StringBuilder buffer = new StringBuilder(value.length());
            for (int i2 = 0; i2 < value.length(); ++i2) {
                char ch = value.charAt(i2);
                if (Character.isLetter(ch)) {
                    buffer.append(Character.toLowerCase(ch));
                }
                if (!Character.isWhitespace(ch)) continue;
                buffer.append('-');
            }
            return buffer.toString();
        }
    }
    ,
    stringFormat{

        @Override
        protected CharSequence safeApply(Object format, Options options2) {
            return String.format(format.toString(), options2.params);
        }
    }
    ,
    stripTags{
        private final Pattern pattern = Pattern.compile("\\<[^>]*>", 32);

        @Override
        protected CharSequence safeApply(Object value, Options options2) {
            Matcher matcher = this.pattern.matcher(value.toString());
            return matcher.replaceAll("");
        }
    }
    ,
    capitalize{

        @Override
        protected CharSequence safeApply(Object value, Options options2) {
            Boolean fully = (Boolean)options2.hash("fully", false);
            return fully != false ? WordUtils.capitalizeFully(value.toString()) : WordUtils.capitalize(value.toString());
        }
    }
    ,
    abbreviate{

        @Override
        protected CharSequence safeApply(Object value, Options options2) {
            Integer width = options2.param(0, null);
            Validate.notNull(width, "found 'null', expected 'width'", new Object[0]);
            return StringUtils.abbreviate(value.toString(), width);
        }
    }
    ,
    wordWrap{

        @Override
        protected CharSequence safeApply(Object value, Options options2) {
            Integer length = options2.param(0, null);
            Validate.notNull(length, "found 'null', expected 'length'", new Object[0]);
            return WordUtils.wrap(value.toString(), length);
        }
    }
    ,
    replace{

        @Override
        public CharSequence safeApply(Object value, Options options2) {
            String target = options2.param(0, null);
            String replacement = options2.param(1, null);
            return value.toString().replace(target, replacement);
        }
    }
    ,
    yesno{

        @Override
        public Object apply(Object value, Options options2) throws IOException {
            if (value == null) {
                return options2.hash("maybe", "maybe");
            }
            Validate.isTrue(value instanceof Boolean, "found '%s', expected 'boolean'", value);
            if (Boolean.TRUE.equals(value)) {
                return options2.hash("yes", "yes");
            }
            return options2.hash("no", "no");
        }

        @Override
        protected CharSequence safeApply(Object context, Options options2) {
            return null;
        }
    }
    ,
    dateFormat{
        private final Map<String, FormatStyle> formatStyles = new HashMap<String, FormatStyle>(4){
            {
                super(x0);
                this.put("full", FormatStyle.FULL);
                this.put("long", FormatStyle.LONG);
                this.put("medium", FormatStyle.MEDIUM);
                this.put("short", FormatStyle.SHORT);
            }
        };

        private TemporalAccessor toTemporalAccessor(Object value) {
            if (value instanceof TemporalAccessor) {
                return (TemporalAccessor)value;
            }
            if (value instanceof Date) {
                return ((Date)value).toInstant();
            }
            String className = null;
            if (value != null) {
                className = value.getClass().getSimpleName();
            }
            throw new IllegalArgumentException(String.format("found instance of %s with value '%s', but expected instance of TemporalAccessor", className, value));
        }

        @Override
        protected CharSequence safeApply(Object value, Options options2) {
            TemporalAccessor date = this.toTemporalAccessor(value);
            String pattern = (String)options2.param(0, options2.hash("format", "medium"));
            FormatStyle dateStyle = this.formatStyles.get(pattern);
            FormatStyle timeStyle = this.formatStyles.get(options2.hash("time"));
            DateTimeFormatter formatter = dateStyle == null ? DateTimeFormatter.ofPattern(pattern) : (timeStyle != null ? DateTimeFormatter.ofLocalizedDateTime(dateStyle, timeStyle) : DateTimeFormatter.ofLocalizedDate(dateStyle));
            String localeStr = (String)options2.param(1, options2.hash("locale"));
            Locale locale = localeStr != null && localeStr.length() > 0 ? LocaleUtils.toLocale(localeStr) : Locale.getDefault();
            formatter = formatter.withLocale(locale);
            Object tz = options2.hash("tz");
            if (tz != null) {
                ZoneId zoneId = tz instanceof ZoneId ? (ZoneId)tz : (tz instanceof TimeZone ? ((TimeZone)tz).toZoneId() : TimeZone.getTimeZone(tz.toString()).toZoneId());
                formatter = formatter.withZone(zoneId);
            } else {
                formatter = formatter.withZone(ZoneId.systemDefault());
            }
            return formatter.format(date);
        }
    }
    ,
    numberFormat{

        @Override
        public Object apply(Object context, Options options2) throws IOException {
            if (context instanceof Number) {
                return this.safeApply(context, options2);
            }
            Object param = options2.param(0, null);
            return param == null ? null : param.toString();
        }

        @Override
        protected CharSequence safeApply(Object value, Options options2) {
            String roundingMode;
            Boolean parseIntegerOnly;
            Integer minimumIntegerDigits;
            Integer minimumFractionDigits;
            Integer maximumIntegerDigits;
            Integer maximumFractionDigits;
            Validate.isTrue(value instanceof Number, "found '%s', expected 'number'", value);
            Number number = (Number)value;
            NumberFormat numberFormat = this.build(options2);
            Boolean groupingUsed = (Boolean)options2.hash("groupingUsed");
            if (groupingUsed != null) {
                numberFormat.setGroupingUsed(groupingUsed);
            }
            if ((maximumFractionDigits = (Integer)options2.hash("maximumFractionDigits")) != null) {
                numberFormat.setMaximumFractionDigits(maximumFractionDigits);
            }
            if ((maximumIntegerDigits = (Integer)options2.hash("maximumIntegerDigits")) != null) {
                numberFormat.setMaximumIntegerDigits(maximumIntegerDigits);
            }
            if ((minimumFractionDigits = (Integer)options2.hash("minimumFractionDigits")) != null) {
                numberFormat.setMinimumFractionDigits(minimumFractionDigits);
            }
            if ((minimumIntegerDigits = (Integer)options2.hash("minimumIntegerDigits")) != null) {
                numberFormat.setMinimumIntegerDigits(minimumIntegerDigits);
            }
            if ((parseIntegerOnly = (Boolean)options2.hash("parseIntegerOnly")) != null) {
                numberFormat.setParseIntegerOnly(parseIntegerOnly);
            }
            if ((roundingMode = (String)options2.hash("roundingMode")) != null) {
                numberFormat.setRoundingMode(RoundingMode.valueOf(roundingMode.toUpperCase().trim()));
            }
            return numberFormat.format(number);
        }

        private NumberFormat build(Options options2) {
            if (options2.params.length == 0) {
                return NumberStyle.DEFAULT.numberFormat(Locale.getDefault());
            }
            Validate.isTrue(options2.params[0] instanceof String, "found '%s', expected 'string'", options2.params[0]);
            String format = (String)options2.param(0);
            String localeStr = options2.param(1, Locale.getDefault().toString());
            Locale locale = LocaleUtils.toLocale(localeStr);
            try {
                NumberStyle style = NumberStyle.valueOf(format.toUpperCase().trim());
                return style.numberFormat(locale);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                return NumberStyle.DEFAULT.numberFormat(locale);
            }
            catch (IllegalArgumentException ex) {
                return new DecimalFormat(format, new DecimalFormatSymbols(locale));
            }
        }
    }
    ,
    now{

        @Override
        protected CharSequence safeApply(Object value, Options options2) {
            return dateFormat.safeApply(new Date(), options2);
        }
    };


    @Override
    public Object apply(Object context, Options options2) throws IOException {
        if (options2.isFalsy(context)) {
            Object param = options2.param(0, null);
            return param == null ? null : param.toString();
        }
        return this.safeApply(context, options2);
    }

    protected abstract CharSequence safeApply(Object var1, Options var2);

    public void registerHelper(Handlebars handlebars) {
        Validate.notNull(handlebars, "The handlebars is required.", new Object[0]);
        handlebars.registerHelper(this.name(), (Helper)this);
    }

    public static void register(Handlebars handlebars) {
        StringHelpers[] helpers;
        Validate.notNull(handlebars, "A handlebars object is required.", new Object[0]);
        for (StringHelpers helper : helpers = StringHelpers.values()) {
            helper.registerHelper(handlebars);
        }
    }
}

