/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.github.jknack.handlebars.helper;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import wiremock.com.github.jknack.handlebars.Context;
import wiremock.com.github.jknack.handlebars.Helper;
import wiremock.com.github.jknack.handlebars.Options;
import wiremock.com.github.jknack.handlebars.Template;

public class EachHelper
implements Helper<Object> {
    public static final Helper<Object> INSTANCE = new EachHelper();
    public static final String NAME = "each";

    @Override
    public Object apply(Object context, Options options2) throws IOException {
        if (context instanceof Iterable) {
            Options.Buffer buffer = options2.buffer();
            Iterator loop = ((Iterable)context).iterator();
            int base = (Integer)options2.hash("base", 0);
            int index = base;
            boolean even = index % 2 == 0;
            Context parent = options2.context;
            Template fn = options2.fn;
            while (loop.hasNext()) {
                Object it = loop.next();
                Context itCtx = Context.newContext(parent, it);
                itCtx.combine("@key", index).combine("@index", index).combine("@first", index == base ? "first" : "").combine("@last", !loop.hasNext() ? "last" : "").combine("@odd", even ? "" : "odd").combine("@even", even ? "even" : "").combine("@index_1", index + 1);
                buffer.append(options2.apply(fn, itCtx, Arrays.asList(it, index)));
                ++index;
                even = !even;
            }
            if (base == index) {
                buffer.append(options2.inverse());
            }
            return buffer;
        }
        if (context != null) {
            int index = 0;
            Iterator<Map.Entry<String, Object>> loop = options2.propertySet(context).iterator();
            Context parent = options2.context;
            boolean first = true;
            Options.Buffer buffer = options2.buffer();
            Template fn = options2.fn;
            while (loop.hasNext()) {
                Map.Entry<String, Object> entry = loop.next();
                String key = entry.getKey();
                Object value = entry.getValue();
                Context itCtx = Context.newBuilder(parent, value).combine("@key", key).combine("@index", index).combine("@first", first ? "first" : "").combine("@last", !loop.hasNext() ? "last" : "").build();
                buffer.append(options2.apply(fn, itCtx, Arrays.asList(value, key)));
                first = false;
                ++index;
            }
            if (first) {
                buffer.append(options2.inverse());
            }
            return buffer;
        }
        return options2.inverse();
    }
}

