/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.spring.internal;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.MergedContextConfiguration;
import org.wiremock.spring.ConfigureWireMock;
import org.wiremock.spring.internal.Store;
import org.wiremock.spring.internal.WireMockServerCreator;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class WireMockContextCustomizer
implements ContextCustomizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(WireMockContextCustomizer.class);
    private final List<ConfigureWireMock> configuration;

    public WireMockContextCustomizer(List<ConfigureWireMock> configurations) {
        this.configuration = configurations;
    }

    public WireMockContextCustomizer(ConfigureWireMock ... configurations) {
        this(Arrays.asList(configurations));
    }

    @Override
    public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedConfig) {
        for (ConfigureWireMock configureWiremock : this.configuration) {
            WireMockServer wireMockServer = this.resolveOrCreateWireMockServer(context, configureWiremock);
            if (this.configuration.size() != 1) continue;
            WireMock.configureFor(wireMockServer.port());
        }
    }

    private WireMockServer resolveOrCreateWireMockServer(ConfigurableApplicationContext context, ConfigureWireMock options2) {
        WireMockServer wireMockServer = Store.INSTANCE.findWireMockInstance(context, options2.name());
        if (wireMockServer == null) {
            return new WireMockServerCreator(options2.name()).createWireMockServer(context, options2);
        }
        LOGGER.info("WireMockServer with name '{}' is already configured", (Object)options2.name());
        return wireMockServer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WireMockContextCustomizer that = (WireMockContextCustomizer)o;
        return Objects.equals(this.configuration, that.configuration);
    }

    public int hashCode() {
        return Objects.hash(this.configuration);
    }
}

