/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.result;

import org.springframework.test.util.AssertionErrors;
import org.springframework.test.web.servlet.ResultMatcher;
import org.springframework.web.servlet.ModelAndView;
import wiremock.org.hamcrest.Matcher;
import wiremock.org.hamcrest.MatcherAssert;

public class ViewResultMatchers {
    protected ViewResultMatchers() {
    }

    public ResultMatcher name(Matcher<? super String> matcher) {
        return result -> {
            ModelAndView mav = result.getModelAndView();
            if (mav == null) {
                AssertionErrors.fail("No ModelAndView found");
            }
            MatcherAssert.assertThat("View name", mav.getViewName(), matcher);
        };
    }

    public ResultMatcher name(String expectedViewName) {
        return result -> {
            ModelAndView mav = result.getModelAndView();
            if (mav == null) {
                AssertionErrors.fail("No ModelAndView found");
            }
            AssertionErrors.assertEquals("View name", expectedViewName, mav.getViewName());
        };
    }
}

