/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.result;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.result.ModelResultMatchers;
import wiremock.org.hamcrest.Matcher;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001J\"\u0010\b\u001a\u00020\t\"\u0004\b\u0000\u0010\r2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000fJ\u001f\u0010\u0010\u001a\u00020\t2\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0011\"\u00020\u000b\u00a2\u0006\u0002\u0010\u0012J\u0016\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015J\u001f\u0010\u0016\u001a\u00020\t2\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0011\"\u00020\u000b\u00a2\u0006\u0002\u0010\u0012J\u001f\u0010\u0017\u001a\u00020\t2\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0011\"\u00020\u000b\u00a2\u0006\u0002\u0010\u0012J\u001e\u0010\u0018\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000bJ$\u0010\u0018\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fJ'\u0010\u001b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0011\"\u00020\u000b\u00a2\u0006\u0002\u0010\u001dJ\u001f\u0010\u001e\u001a\u00020\t2\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0011\"\u00020\u000b\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010\u001f\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010 \u001a\u00020\tJ\u0006\u0010!\u001a\u00020\tJ\u000e\u0010\"\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/springframework/test/web/servlet/result/ModelResultMatchersDsl;", "", "actions", "Lorg/springframework/test/web/servlet/ResultActions;", "(Lorg/springframework/test/web/servlet/ResultActions;)V", "matchers", "Lorg/springframework/test/web/servlet/result/ModelResultMatchers;", "kotlin.jvm.PlatformType", "attribute", "", "name", "", "value", "T", "matcher", "Lwiremock/org/hamcrest/Matcher;", "attributeDoesNotExist", "", "([Ljava/lang/String;)V", "attributeErrorCount", "expectedCount", "", "attributeExists", "attributeHasErrors", "attributeHasFieldErrorCode", "fieldName", "code", "attributeHasFieldErrors", "fieldNames", "(Ljava/lang/String;[Ljava/lang/String;)V", "attributeHasNoErrors", "errorCount", "hasErrors", "hasNoErrors", "size", "spring-test"})
public final class ModelResultMatchersDsl {
    @NotNull
    private final ResultActions actions;
    private final ModelResultMatchers matchers;

    public ModelResultMatchersDsl(@NotNull ResultActions actions) {
        Intrinsics.checkNotNullParameter((Object)actions, (String)"actions");
        this.actions = actions;
        this.matchers = MockMvcResultMatchers.model();
    }

    public final <T> void attribute(@NotNull String name, @NotNull Matcher<T> matcher) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(matcher, (String)"matcher");
        this.actions.andExpect(this.matchers.attribute(name, matcher));
    }

    public final void attribute(@NotNull String name, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.actions.andExpect(this.matchers.attribute(name, value));
    }

    public final void attributeExists(String ... name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.actions.andExpect(this.matchers.attributeExists(Arrays.copyOf(name, name.length)));
    }

    public final void attributeDoesNotExist(String ... name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.actions.andExpect(this.matchers.attributeDoesNotExist(Arrays.copyOf(name, name.length)));
    }

    public final void attributeErrorCount(@NotNull String name, int expectedCount) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.actions.andExpect(this.matchers.attributeErrorCount(name, expectedCount));
    }

    public final void attributeHasErrors(String ... name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.actions.andExpect(this.matchers.attributeHasErrors(Arrays.copyOf(name, name.length)));
    }

    public final void attributeHasNoErrors(String ... name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.actions.andExpect(this.matchers.attributeHasNoErrors(Arrays.copyOf(name, name.length)));
    }

    public final void attributeHasFieldErrors(@NotNull String name, String ... fieldNames) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)fieldNames, (String)"fieldNames");
        this.actions.andExpect(this.matchers.attributeHasFieldErrors(name, Arrays.copyOf(fieldNames, fieldNames.length)));
    }

    public final void attributeHasFieldErrorCode(@NotNull String name, @NotNull String fieldName, @NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        this.actions.andExpect(this.matchers.attributeHasFieldErrorCode(name, fieldName, code));
    }

    public final void attributeHasFieldErrorCode(@NotNull String name, @NotNull String fieldName, @NotNull Matcher<String> matcher) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter(matcher, (String)"matcher");
        this.actions.andExpect(this.matchers.attributeHasFieldErrorCode(name, fieldName, matcher));
    }

    public final void errorCount(int expectedCount) {
        this.actions.andExpect(this.matchers.errorCount(expectedCount));
    }

    public final void hasErrors() {
        this.actions.andExpect(this.matchers.hasErrors());
    }

    public final void hasNoErrors() {
        this.actions.andExpect(this.matchers.hasNoErrors());
    }

    public final void size(int size) {
        this.actions.andExpect(this.matchers.size(size));
    }
}

