/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.SpringProperties;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.lang.Nullable;
import org.springframework.test.context.TestConstructor;
import org.springframework.test.context.TestContextAnnotationUtils;
import org.springframework.test.context.support.PropertyProvider;
import org.springframework.util.ClassUtils;
import wiremock.org.apache.commons.logging.Log;
import wiremock.org.apache.commons.logging.LogFactory;

public abstract class TestConstructorUtils {
    private static final Log logger = LogFactory.getLog(TestConstructorUtils.class);
    private static final Set<Class<? extends Annotation>> autowiredAnnotationTypes = new LinkedHashSet<Class<? extends Annotation>>(2);

    private TestConstructorUtils() {
    }

    public static boolean isAutowirableConstructor(Executable executable, Class<?> testClass) {
        return TestConstructorUtils.isAutowirableConstructor(executable, testClass, null);
    }

    public static boolean isAutowirableConstructor(Constructor<?> constructor, Class<?> testClass) {
        return TestConstructorUtils.isAutowirableConstructor(constructor, testClass, null);
    }

    public static boolean isAutowirableConstructor(Executable executable, Class<?> testClass, @Nullable PropertyProvider fallbackPropertyProvider) {
        Constructor constructor;
        return executable instanceof Constructor && TestConstructorUtils.isAutowirableConstructor(constructor = (Constructor)executable, testClass, fallbackPropertyProvider);
    }

    public static boolean isAutowirableConstructor(Constructor<?> constructor, Class<?> testClass, @Nullable PropertyProvider fallbackPropertyProvider) {
        TestConstructor.AutowireMode autowireMode;
        if (TestConstructorUtils.isAnnotatedWithAutowiredOrInject(constructor)) {
            return true;
        }
        TestConstructor testConstructor = TestContextAnnotationUtils.findMergedAnnotation(testClass, TestConstructor.class);
        if (testConstructor != null) {
            autowireMode = testConstructor.autowireMode();
        } else {
            String value = SpringProperties.getProperty("spring.test.constructor.autowire.mode");
            autowireMode = TestConstructor.AutowireMode.from(value);
            if (autowireMode == null && fallbackPropertyProvider != null) {
                value = fallbackPropertyProvider.get("spring.test.constructor.autowire.mode");
                autowireMode = TestConstructor.AutowireMode.from(value);
            }
        }
        return autowireMode == TestConstructor.AutowireMode.ALL;
    }

    private static boolean isAnnotatedWithAutowiredOrInject(Constructor<?> constructor) {
        return autowiredAnnotationTypes.stream().anyMatch(annotationType -> AnnotatedElementUtils.hasAnnotation(constructor, annotationType));
    }

    static {
        autowiredAnnotationTypes.add(Autowired.class);
        ClassLoader classLoader = TestConstructorUtils.class.getClassLoader();
        try {
            autowiredAnnotationTypes.add(ClassUtils.forName("jakarta.inject.Inject", classLoader));
            logger.trace("'jakarta.inject.Inject' annotation found and supported for autowiring");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            autowiredAnnotationTypes.add(ClassUtils.forName("javax.inject.Inject", classLoader));
            logger.trace("'javax.inject.Inject' annotation found and supported for autowiring");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

