/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.springframework.beans.BeanUtils;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.ActiveProfilesResolver;
import org.springframework.test.context.TestContextAnnotationUtils;
import org.springframework.test.context.support.DefaultActiveProfilesResolver;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import wiremock.org.apache.commons.logging.Log;
import wiremock.org.apache.commons.logging.LogFactory;

abstract class ActiveProfilesUtils {
    private static final Log logger = LogFactory.getLog(ActiveProfilesUtils.class);
    private static final DefaultActiveProfilesResolver defaultActiveProfilesResolver = new DefaultActiveProfilesResolver();

    ActiveProfilesUtils() {
    }

    static String[] resolveActiveProfiles(Class<?> testClass) {
        Assert.notNull(testClass, "Class must not be null");
        TestContextAnnotationUtils.AnnotationDescriptor<ActiveProfiles> descriptor = TestContextAnnotationUtils.findAnnotationDescriptor(testClass, ActiveProfiles.class);
        ArrayList<Object[]> profileArrays = new ArrayList<Object[]>();
        if (descriptor == null && logger.isTraceEnabled()) {
            logger.trace("Could not find an 'annotation declaring class' for annotation type [%s] and class [%s]".formatted(ActiveProfiles.class.getName(), testClass.getName()));
        }
        while (descriptor != null) {
            ActiveProfilesResolver resolver;
            Class<? extends ActiveProfilesResolver> resolverClass;
            Class<?> rootDeclaringClass = descriptor.getRootDeclaringClass();
            ActiveProfiles annotation = descriptor.getAnnotation();
            if (logger.isTraceEnabled()) {
                logger.trace("Retrieved @ActiveProfiles [%s] for declaring class [%s]".formatted(annotation, descriptor.getDeclaringClass().getName()));
            }
            if (ActiveProfilesResolver.class == (resolverClass = annotation.resolver())) {
                resolver = defaultActiveProfilesResolver;
            } else {
                try {
                    resolver = BeanUtils.instantiateClass(resolverClass, ActiveProfilesResolver.class);
                }
                catch (Exception ex) {
                    String msg = "Could not instantiate ActiveProfilesResolver of type [%s] for test class [%s]".formatted(resolverClass.getName(), rootDeclaringClass.getName());
                    logger.error(msg);
                    throw new IllegalStateException(msg, ex);
                }
            }
            Object[] profiles = resolver.resolve(rootDeclaringClass);
            if (!ObjectUtils.isEmpty(profiles)) {
                profileArrays.add(0, profiles);
            }
            descriptor = annotation.inheritProfiles() ? descriptor.next() : null;
        }
        LinkedHashSet<String> activeProfiles = new LinkedHashSet<String>();
        Iterator iterator = profileArrays.iterator();
        while (iterator.hasNext()) {
            String[] profiles;
            for (String profile2 : profiles = (String[])iterator.next()) {
                if (!StringUtils.hasText(profile2)) continue;
                activeProfiles.add(profile2.trim());
            }
        }
        return StringUtils.toStringArray(activeProfiles);
    }
}

