/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.cache;

import org.springframework.core.SpringProperties;
import org.springframework.util.StringUtils;

public abstract class ContextCacheUtils {
    public static int retrieveMaxCacheSize() {
        String propertyName = "spring.test.context.cache.maxSize";
        int defaultValue = 32;
        return ContextCacheUtils.retrieveProperty(propertyName, defaultValue);
    }

    public static int retrieveContextFailureThreshold() {
        String propertyName = "spring.test.context.failure.threshold";
        int defaultValue = 1;
        return ContextCacheUtils.retrieveProperty(propertyName, defaultValue);
    }

    private static int retrieveProperty(String key, int defaultValue) {
        try {
            String value = SpringProperties.getProperty(key);
            if (StringUtils.hasText(value)) {
                return Integer.parseInt(value.trim());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }
}

