/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web;

import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.mock.web.MockServletContext;
import org.springframework.util.Assert;
import wiremock.jakarta.servlet.ServletContext;
import wiremock.jakarta.servlet.http.HttpSession;
import wiremock.jakarta.servlet.http.HttpSessionBindingEvent;
import wiremock.jakarta.servlet.http.HttpSessionBindingListener;

public class MockHttpSession
implements HttpSession {
    public static final String SESSION_COOKIE_NAME = "JSESSION";
    private static int nextId = 1;
    private String id;
    private final long creationTime = System.currentTimeMillis();
    private int maxInactiveInterval;
    private long lastAccessedTime = System.currentTimeMillis();
    private final ServletContext servletContext;
    private final Map<String, Object> attributes = new LinkedHashMap<String, Object>();
    private boolean invalid = false;
    private boolean isNew = true;

    public MockHttpSession() {
        this(null);
    }

    public MockHttpSession(@Nullable ServletContext servletContext) {
        this(servletContext, null);
    }

    public MockHttpSession(@Nullable ServletContext servletContext, @Nullable String id) {
        this.servletContext = servletContext != null ? servletContext : new MockServletContext();
        this.id = id != null ? id : Integer.toString(nextId++);
    }

    @Override
    public long getCreationTime() {
        this.assertIsValid();
        return this.creationTime;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String changeSessionId() {
        this.id = Integer.toString(nextId++);
        return this.id;
    }

    public void access() {
        this.lastAccessedTime = System.currentTimeMillis();
        this.isNew = false;
    }

    @Override
    public long getLastAccessedTime() {
        this.assertIsValid();
        return this.lastAccessedTime;
    }

    @Override
    public ServletContext getServletContext() {
        return this.servletContext;
    }

    @Override
    public void setMaxInactiveInterval(int interval) {
        this.maxInactiveInterval = interval;
    }

    @Override
    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    @Override
    @Nullable
    public Object getAttribute(String name) {
        this.assertIsValid();
        Assert.notNull((Object)name, "Attribute name must not be null");
        return this.attributes.get(name);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        this.assertIsValid();
        return Collections.enumeration(new LinkedHashSet<String>(this.attributes.keySet()));
    }

    @Override
    public void setAttribute(String name, @Nullable Object value) {
        this.assertIsValid();
        Assert.notNull((Object)name, "Attribute name must not be null");
        if (value != null) {
            Object oldValue = this.attributes.put(name, value);
            if (value != oldValue) {
                HttpSessionBindingListener listener;
                if (oldValue instanceof HttpSessionBindingListener) {
                    listener = (HttpSessionBindingListener)oldValue;
                    listener.valueUnbound(new HttpSessionBindingEvent(this, name, oldValue));
                }
                if (value instanceof HttpSessionBindingListener) {
                    listener = (HttpSessionBindingListener)value;
                    listener.valueBound(new HttpSessionBindingEvent(this, name, value));
                }
            }
        } else {
            this.removeAttribute(name);
        }
    }

    @Override
    public void removeAttribute(String name) {
        this.assertIsValid();
        Assert.notNull((Object)name, "Attribute name must not be null");
        Object value = this.attributes.remove(name);
        if (value instanceof HttpSessionBindingListener) {
            HttpSessionBindingListener listener = (HttpSessionBindingListener)value;
            listener.valueUnbound(new HttpSessionBindingEvent(this, name, value));
        }
    }

    public void clearAttributes() {
        Iterator<Map.Entry<String, Object>> it = this.attributes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            String name = entry.getKey();
            Object value = entry.getValue();
            it.remove();
            if (!(value instanceof HttpSessionBindingListener)) continue;
            HttpSessionBindingListener listener = (HttpSessionBindingListener)value;
            listener.valueUnbound(new HttpSessionBindingEvent(this, name, value));
        }
    }

    @Override
    public void invalidate() {
        this.assertIsValid();
        this.invalid = true;
        this.clearAttributes();
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    private void assertIsValid() {
        Assert.state(!this.isInvalid(), "The session has already been invalidated");
    }

    public void setNew(boolean value) {
        this.isNew = value;
    }

    @Override
    public boolean isNew() {
        this.assertIsValid();
        return this.isNew;
    }

    public Serializable serializeState() {
        HashMap<String, Serializable> state = new HashMap<String, Serializable>();
        Iterator<Map.Entry<String, Object>> it = this.attributes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            String name = entry.getKey();
            Object value = entry.getValue();
            it.remove();
            if (value instanceof Serializable) {
                Serializable serializable = (Serializable)value;
                state.put(name, serializable);
                continue;
            }
            if (!(value instanceof HttpSessionBindingListener)) continue;
            HttpSessionBindingListener listener = (HttpSessionBindingListener)value;
            listener.valueUnbound(new HttpSessionBindingEvent(this, name, value));
        }
        return state;
    }

    public void deserializeState(Serializable state) {
        Assert.isTrue(state instanceof Map, "Serialized state needs to be of type [java.util.Map]");
        this.attributes.putAll((Map)((Object)state));
    }
}

