/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import wiremock.jakarta.servlet.Filter;
import wiremock.jakarta.servlet.FilterChain;
import wiremock.jakarta.servlet.FilterConfig;
import wiremock.jakarta.servlet.Servlet;
import wiremock.jakarta.servlet.ServletException;
import wiremock.jakarta.servlet.ServletRequest;
import wiremock.jakarta.servlet.ServletResponse;

public class MockFilterChain
implements FilterChain {
    @Nullable
    private ServletRequest request;
    @Nullable
    private ServletResponse response;
    private final List<Filter> filters;
    @Nullable
    private Iterator<Filter> iterator;

    public MockFilterChain() {
        this.filters = Collections.emptyList();
    }

    public MockFilterChain(Servlet servlet) {
        this.filters = MockFilterChain.initFilterList(servlet, new Filter[0]);
    }

    public MockFilterChain(Servlet servlet, Filter ... filters) {
        Assert.notNull((Object)filters, "filters cannot be null");
        Assert.noNullElements((Object[])filters, "filters cannot contain null values");
        this.filters = MockFilterChain.initFilterList(servlet, filters);
    }

    private static List<Filter> initFilterList(Servlet servlet, Filter ... filters) {
        Filter[] allFilters = ObjectUtils.addObjectToArray(filters, new ServletFilterProxy(servlet));
        return List.of(allFilters);
    }

    @Nullable
    public ServletRequest getRequest() {
        return this.request;
    }

    @Nullable
    public ServletResponse getResponse() {
        return this.response;
    }

    @Override
    public void doFilter(ServletRequest request2, ServletResponse response) throws IOException, ServletException {
        Assert.notNull((Object)request2, "Request must not be null");
        Assert.notNull((Object)response, "Response must not be null");
        Assert.state(this.request == null, "This FilterChain has already been called!");
        if (this.iterator == null) {
            this.iterator = this.filters.iterator();
        }
        if (this.iterator.hasNext()) {
            Filter nextFilter = this.iterator.next();
            nextFilter.doFilter(request2, response, this);
        }
        this.request = request2;
        this.response = response;
    }

    public void reset() {
        this.request = null;
        this.response = null;
        this.iterator = null;
    }

    private static final class ServletFilterProxy
    implements Filter {
        private final Servlet delegateServlet;

        private ServletFilterProxy(Servlet servlet) {
            Assert.notNull((Object)servlet, "servlet cannot be null");
            this.delegateServlet = servlet;
        }

        @Override
        public void doFilter(ServletRequest request2, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            this.delegateServlet.service(request2, response);
        }

        @Override
        public void init(FilterConfig filterConfig) throws ServletException {
        }

        @Override
        public void destroy() {
        }

        public String toString() {
            return this.delegateServlet.toString();
        }
    }
}

