/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web;

import java.time.DateTimeException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.springframework.core.style.ToStringCreator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import wiremock.jakarta.servlet.http.Cookie;

public class MockCookie
extends Cookie {
    private static final long serialVersionUID = 4312531139502726325L;
    private static final String SAME_SITE = "SameSite";
    private static final String EXPIRES = "Expires";
    @Nullable
    private ZonedDateTime expires;

    public MockCookie(String name, String value) {
        super(name, value);
    }

    public void setExpires(@Nullable ZonedDateTime expires) {
        this.setAttribute(EXPIRES, expires != null ? expires.format(DateTimeFormatter.RFC_1123_DATE_TIME) : null);
    }

    @Nullable
    public ZonedDateTime getExpires() {
        return this.expires;
    }

    public void setSameSite(@Nullable String sameSite) {
        this.setAttribute(SAME_SITE, sameSite);
    }

    @Nullable
    public String getSameSite() {
        return this.getAttribute(SAME_SITE);
    }

    public static MockCookie parse(String setCookieHeader) {
        Assert.notNull((Object)setCookieHeader, "Set-Cookie header must not be null");
        String[] cookieParts = setCookieHeader.split("\\s*=\\s*", 2);
        Assert.isTrue(cookieParts.length == 2, () -> "Invalid Set-Cookie header '" + setCookieHeader + "'");
        String name = cookieParts[0];
        String[] valueAndAttributes = cookieParts[1].split("\\s*;\\s*", 2);
        String value = valueAndAttributes[0];
        String[] attributes = valueAndAttributes.length > 1 ? valueAndAttributes[1].split("\\s*;\\s*") : new String[]{};
        MockCookie cookie = new MockCookie(name, value);
        for (String attribute : attributes) {
            if (StringUtils.startsWithIgnoreCase(attribute, "Domain")) {
                cookie.setDomain(MockCookie.extractAttributeValue(attribute, setCookieHeader));
                continue;
            }
            if (StringUtils.startsWithIgnoreCase(attribute, "Max-Age")) {
                cookie.setMaxAge(Integer.parseInt(MockCookie.extractAttributeValue(attribute, setCookieHeader)));
                continue;
            }
            if (StringUtils.startsWithIgnoreCase(attribute, EXPIRES)) {
                try {
                    cookie.setExpires(ZonedDateTime.parse(MockCookie.extractAttributeValue(attribute, setCookieHeader), DateTimeFormatter.RFC_1123_DATE_TIME));
                }
                catch (DateTimeException dateTimeException) {}
                continue;
            }
            if (StringUtils.startsWithIgnoreCase(attribute, "Path")) {
                cookie.setPath(MockCookie.extractAttributeValue(attribute, setCookieHeader));
                continue;
            }
            if (StringUtils.startsWithIgnoreCase(attribute, "Secure")) {
                cookie.setSecure(true);
                continue;
            }
            if (StringUtils.startsWithIgnoreCase(attribute, "HttpOnly")) {
                cookie.setHttpOnly(true);
                continue;
            }
            if (StringUtils.startsWithIgnoreCase(attribute, SAME_SITE)) {
                cookie.setSameSite(MockCookie.extractAttributeValue(attribute, setCookieHeader));
                continue;
            }
            if (!StringUtils.startsWithIgnoreCase(attribute, "Comment")) continue;
            cookie.setComment(MockCookie.extractAttributeValue(attribute, setCookieHeader));
        }
        return cookie;
    }

    private static String extractAttributeValue(String attribute, String header) {
        String[] nameAndValue = attribute.split("=");
        Assert.isTrue(nameAndValue.length == 2, () -> "No value in attribute '" + nameAndValue[0] + "' for Set-Cookie header '" + header + "'");
        return nameAndValue[1];
    }

    public void setAttribute(String name, @Nullable String value) {
        if (EXPIRES.equalsIgnoreCase(name)) {
            this.expires = value != null ? ZonedDateTime.parse(value, DateTimeFormatter.RFC_1123_DATE_TIME) : null;
        }
        super.setAttribute(name, value);
    }

    public String toString() {
        return new ToStringCreator(this).append("name", this.getName()).append("value", this.getValue()).append("Path", this.getPath()).append("Domain", this.getDomain()).append("Version", this.getVersion()).append("Comment", this.getComment()).append("Secure", this.getSecure()).append("HttpOnly", this.isHttpOnly()).append(SAME_SITE, this.getSameSite()).append("Max-Age", this.getMaxAge()).append(EXPIRES, this.getAttribute(EXPIRES)).toString();
    }
}

