/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.embedded.tomcat;

import java.util.Set;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import wiremock.jakarta.servlet.ServletContainerInitializer;
import wiremock.jakarta.servlet.ServletContext;
import wiremock.jakarta.servlet.ServletException;
import wiremock.org.apache.commons.logging.Log;
import wiremock.org.apache.commons.logging.LogFactory;

class TomcatStarter
implements ServletContainerInitializer {
    private static final Log logger = LogFactory.getLog(TomcatStarter.class);
    private final ServletContextInitializer[] initializers;
    private volatile Exception startUpException;

    TomcatStarter(ServletContextInitializer[] initializers) {
        this.initializers = initializers;
    }

    @Override
    public void onStartup(Set<Class<?>> classes, ServletContext servletContext) throws ServletException {
        block3: {
            try {
                for (ServletContextInitializer initializer : this.initializers) {
                    initializer.onStartup(servletContext);
                }
            }
            catch (Exception ex) {
                this.startUpException = ex;
                if (!logger.isErrorEnabled()) break block3;
                logger.error("Error starting Tomcat context. Exception: " + ex.getClass().getName() + ". Message: " + ex.getMessage());
            }
        }
    }

    Exception getStartUpException() {
        return this.startUpException;
    }
}

