/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.embedded.tomcat;

import org.springframework.boot.web.embedded.tomcat.TomcatConnectorCustomizer;
import org.springframework.boot.web.server.Compression;
import org.springframework.util.StringUtils;
import wiremock.org.apache.catalina.connector.Connector;
import wiremock.org.apache.coyote.ProtocolHandler;
import wiremock.org.apache.coyote.http11.AbstractHttp11Protocol;

class CompressionConnectorCustomizer
implements TomcatConnectorCustomizer {
    private final Compression compression;

    CompressionConnectorCustomizer(Compression compression) {
        this.compression = compression;
    }

    @Override
    public void customize(Connector connector) {
        ProtocolHandler handler;
        if (this.compression != null && this.compression.getEnabled() && (handler = connector.getProtocolHandler()) instanceof AbstractHttp11Protocol) {
            AbstractHttp11Protocol abstractHttp11Protocol = (AbstractHttp11Protocol)handler;
            this.customize(abstractHttp11Protocol);
        }
    }

    private void customize(AbstractHttp11Protocol<?> protocol) {
        Compression compression = this.compression;
        protocol.setCompression("on");
        protocol.setCompressionMinSize(this.getMinResponseSize(compression));
        protocol.setCompressibleMimeType(this.getMimeTypes(compression));
        if (this.compression.getExcludedUserAgents() != null) {
            protocol.setNoCompressionUserAgents(this.getExcludedUserAgents());
        }
    }

    private int getMinResponseSize(Compression compression) {
        return (int)compression.getMinResponseSize().toBytes();
    }

    private String getMimeTypes(Compression compression) {
        return StringUtils.arrayToCommaDelimitedString(compression.getMimeTypes());
    }

    private String getExcludedUserAgents() {
        return StringUtils.arrayToCommaDelimitedString(this.compression.getExcludedUserAgents());
    }
}

