/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.embedded.jetty;

import wiremock.org.eclipse.jetty.ee10.servlet.ServletHandler;
import wiremock.org.eclipse.jetty.ee10.webapp.WebAppContext;
import wiremock.org.eclipse.jetty.util.ClassMatcher;

class JettyEmbeddedWebAppContext
extends WebAppContext {
    JettyEmbeddedWebAppContext() {
        this.setHiddenClassMatcher(new ClassMatcher("org.springframework.boot.loader."));
    }

    protected ServletHandler newServletHandler() {
        return new JettyEmbeddedServletHandler();
    }

    void deferredInitialize() throws Exception {
        JettyEmbeddedServletHandler handler = (JettyEmbeddedServletHandler)this.getServletHandler();
        this.getContext().call(handler::deferredInitialize, null);
    }

    public String getCanonicalNameForTmpDir() {
        return super.getCanonicalNameForTmpDir();
    }

    private static final class JettyEmbeddedServletHandler
    extends ServletHandler {
        private JettyEmbeddedServletHandler() {
        }

        public void initialize() throws Exception {
        }

        void deferredInitialize() throws Exception {
            super.initialize();
        }
    }
}

