/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.web.client;

import org.springframework.aot.AotDetector;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.client.LocalHostUriTemplateHandler;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.boot.web.servlet.server.AbstractServletWebServerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.TestContextAnnotationUtils;

class TestRestTemplateContextCustomizer
implements ContextCustomizer {
    TestRestTemplateContextCustomizer() {
    }

    @Override
    public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedContextConfiguration) {
        if (AotDetector.useGeneratedArtifacts()) {
            return;
        }
        SpringBootTest springBootTest = TestContextAnnotationUtils.findMergedAnnotation(mergedContextConfiguration.getTestClass(), SpringBootTest.class);
        if (springBootTest.webEnvironment().isEmbedded()) {
            this.registerTestRestTemplate(context);
        }
    }

    private void registerTestRestTemplate(ConfigurableApplicationContext context) {
        ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
        if (beanFactory instanceof BeanDefinitionRegistry) {
            BeanDefinitionRegistry registry = (BeanDefinitionRegistry)((Object)beanFactory);
            this.registerTestRestTemplate(registry);
        }
    }

    private void registerTestRestTemplate(BeanDefinitionRegistry registry) {
        RootBeanDefinition definition = new RootBeanDefinition(TestRestTemplateRegistrar.class);
        definition.setRole(2);
        registry.registerBeanDefinition(TestRestTemplateRegistrar.class.getName(), definition);
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    static class TestRestTemplateRegistrar
    implements BeanDefinitionRegistryPostProcessor,
    Ordered,
    BeanFactoryAware {
        private BeanFactory beanFactory;

        TestRestTemplateRegistrar() {
        }

        @Override
        public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
            this.beanFactory = beanFactory;
        }

        @Override
        public int getOrder() {
            return Integer.MAX_VALUE;
        }

        @Override
        public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
            if (AotDetector.useGeneratedArtifacts()) {
                return;
            }
            if (BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, TestRestTemplate.class, false, false).length == 0) {
                registry.registerBeanDefinition(TestRestTemplate.class.getName(), new RootBeanDefinition(TestRestTemplateFactory.class));
            }
        }

        @Override
        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        }
    }

    public static class TestRestTemplateFactory
    implements FactoryBean<TestRestTemplate>,
    ApplicationContextAware {
        private static final TestRestTemplate.HttpClientOption[] DEFAULT_OPTIONS = new TestRestTemplate.HttpClientOption[0];
        private static final TestRestTemplate.HttpClientOption[] SSL_OPTIONS = new TestRestTemplate.HttpClientOption[]{TestRestTemplate.HttpClientOption.SSL};
        private TestRestTemplate template;

        @Override
        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            RestTemplateBuilder builder = this.getRestTemplateBuilder(applicationContext);
            boolean sslEnabled = this.isSslEnabled(applicationContext);
            TestRestTemplate template = new TestRestTemplate(builder, null, null, sslEnabled ? SSL_OPTIONS : DEFAULT_OPTIONS);
            LocalHostUriTemplateHandler handler = new LocalHostUriTemplateHandler(applicationContext.getEnvironment(), sslEnabled ? "https" : "http");
            template.setUriTemplateHandler(handler);
            this.template = template;
        }

        private boolean isSslEnabled(ApplicationContext context) {
            try {
                AbstractServletWebServerFactory webServerFactory = context.getBean(AbstractServletWebServerFactory.class);
                return webServerFactory.getSsl() != null && webServerFactory.getSsl().isEnabled();
            }
            catch (NoSuchBeanDefinitionException ex) {
                return false;
            }
        }

        private RestTemplateBuilder getRestTemplateBuilder(ApplicationContext applicationContext) {
            try {
                return applicationContext.getBean(RestTemplateBuilder.class);
            }
            catch (NoSuchBeanDefinitionException ex) {
                return new RestTemplateBuilder(new RestTemplateCustomizer[0]);
            }
        }

        @Override
        public boolean isSingleton() {
            return true;
        }

        @Override
        public Class<?> getObjectType() {
            return TestRestTemplate.class;
        }

        @Override
        public TestRestTemplate getObject() throws Exception {
            return this.template;
        }
    }
}

