/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.web;

import java.util.Map;
import java.util.Objects;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.ClassUtils;

class SpringBootTestRandomPortEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    private static final String MANAGEMENT_PORT_PROPERTY = "management.server.port";
    private static final String SERVER_PORT_PROPERTY = "server.port";

    SpringBootTestRandomPortEnvironmentPostProcessor() {
    }

    @Override
    public void postProcessEnvironment(ConfigurableEnvironment environment2, SpringApplication application) {
        MapPropertySource source = (MapPropertySource)environment2.getPropertySources().get("Inlined Test Properties");
        if (source == null || this.isTestServerPortFixed(source, environment2) || this.isTestManagementPortConfigured(source)) {
            return;
        }
        Integer managementPort = this.getPropertyAsInteger(environment2, MANAGEMENT_PORT_PROPERTY, null);
        if (managementPort == null || managementPort.equals(-1) || managementPort.equals(0)) {
            return;
        }
        Integer serverPort = this.getPropertyAsInteger(environment2, SERVER_PORT_PROPERTY, 8080);
        if (!managementPort.equals(serverPort)) {
            ((Map)source.getSource()).put(MANAGEMENT_PORT_PROPERTY, "0");
        } else {
            ((Map)source.getSource()).put(MANAGEMENT_PORT_PROPERTY, "");
        }
    }

    private boolean isTestServerPortFixed(MapPropertySource source, ConfigurableEnvironment environment2) {
        return !Integer.valueOf(0).equals(this.getPropertyAsInteger(source, SERVER_PORT_PROPERTY, environment2));
    }

    private boolean isTestManagementPortConfigured(PropertySource<?> source) {
        return source.getProperty(MANAGEMENT_PORT_PROPERTY) != null;
    }

    private Integer getPropertyAsInteger(ConfigurableEnvironment environment2, String property, Integer defaultValue) {
        return environment2.getPropertySources().stream().filter(source -> !source.getName().equals("Inlined Test Properties")).map(source -> this.getPropertyAsInteger((PropertySource<?>)source, property, environment2)).filter(Objects::nonNull).findFirst().orElse(defaultValue);
    }

    private Integer getPropertyAsInteger(PropertySource<?> source, String property, ConfigurableEnvironment environment2) {
        Object value = source.getProperty(property);
        if (value == null) {
            return null;
        }
        if (ClassUtils.isAssignableValue(Integer.class, value)) {
            return (Integer)value;
        }
        try {
            return environment2.getConversionService().convert(value, Integer.class);
        }
        catch (ConversionFailedException ex) {
            if (value instanceof String) {
                String string = (String)value;
                return this.getResolvedValueIfPossible(environment2, string);
            }
            throw ex;
        }
    }

    private Integer getResolvedValueIfPossible(ConfigurableEnvironment environment2, String value) {
        String resolvedValue = environment2.resolveRequiredPlaceholders(value);
        return environment2.getConversionService().convert((Object)resolvedValue, Integer.class);
    }
}

