/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import java.lang.reflect.Proxy;
import org.mockito.AdditionalAnswers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.listeners.VerificationStartedEvent;
import org.mockito.listeners.VerificationStartedListener;
import org.springframework.boot.test.mock.mockito.Definition;
import org.springframework.boot.test.mock.mockito.MockReset;
import org.springframework.boot.test.mock.mockito.QualifierDefinition;
import org.springframework.core.ResolvableType;
import org.springframework.core.style.ToStringCreator;
import org.springframework.test.util.AopTestUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

class SpyDefinition
extends Definition {
    private static final int MULTIPLIER = 31;
    private final ResolvableType typeToSpy;

    SpyDefinition(String name, ResolvableType typeToSpy, MockReset reset, boolean proxyTargetAware, QualifierDefinition qualifier) {
        super(name, reset, proxyTargetAware, qualifier);
        Assert.notNull((Object)typeToSpy, "TypeToSpy must not be null");
        this.typeToSpy = typeToSpy;
    }

    ResolvableType getTypeToSpy() {
        return this.typeToSpy;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        SpyDefinition other = (SpyDefinition)obj;
        boolean result = super.equals(obj);
        result = result && ObjectUtils.nullSafeEquals(this.typeToSpy, other.typeToSpy);
        return result;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.typeToSpy);
        return result;
    }

    public String toString() {
        return new ToStringCreator(this).append("name", this.getName()).append("typeToSpy", this.typeToSpy).append("reset", (Object)this.getReset()).toString();
    }

    <T> T createSpy(Object instance) {
        return this.createSpy(this.getName(), instance);
    }

    <T> T createSpy(String name, Object instance) {
        Class<?> toSpy;
        Assert.notNull(instance, "Instance must not be null");
        Assert.isInstanceOf(this.typeToSpy.resolve(), instance);
        if (Mockito.mockingDetails((Object)instance).isSpy()) {
            return (T)instance;
        }
        MockSettings settings = MockReset.withSettings(this.getReset());
        if (StringUtils.hasLength(name)) {
            settings.name(name);
        }
        if (this.isProxyTargetAware()) {
            settings.verificationStartedListeners(new VerificationStartedListener[]{new SpringAopBypassingVerificationStartedListener()});
        }
        if (Proxy.isProxyClass(instance.getClass())) {
            settings.defaultAnswer(AdditionalAnswers.delegatesTo((Object)instance));
            toSpy = this.typeToSpy.toClass();
        } else {
            settings.defaultAnswer(Mockito.CALLS_REAL_METHODS);
            settings.spiedInstance(instance);
            toSpy = instance.getClass();
        }
        return (T)Mockito.mock(toSpy, (MockSettings)settings);
    }

    private static final class SpringAopBypassingVerificationStartedListener
    implements VerificationStartedListener {
        private SpringAopBypassingVerificationStartedListener() {
        }

        public void onVerificationStarted(VerificationStartedEvent event) {
            event.setMock(AopTestUtils.getUltimateTargetObject(event.getMock()));
        }
    }
}

