/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context;

import java.util.Arrays;
import java.util.Objects;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.TestContextAnnotationUtils;

class SpringBootTestAnnotation
implements ContextCustomizer {
    private static final String[] NO_ARGS = new String[0];
    private static final SpringBootTestAnnotation DEFAULT = new SpringBootTestAnnotation((SpringBootTest)null);
    private final String[] args;
    private final SpringBootTest.WebEnvironment webEnvironment;
    private final SpringBootTest.UseMainMethod useMainMethod;

    SpringBootTestAnnotation(Class<?> testClass) {
        this(TestContextAnnotationUtils.findMergedAnnotation(testClass, SpringBootTest.class));
    }

    private SpringBootTestAnnotation(SpringBootTest annotation) {
        this.args = annotation != null ? annotation.args() : NO_ARGS;
        this.webEnvironment = annotation != null ? annotation.webEnvironment() : SpringBootTest.WebEnvironment.NONE;
        this.useMainMethod = annotation != null ? annotation.useMainMethod() : SpringBootTest.UseMainMethod.NEVER;
    }

    @Override
    public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedConfig) {
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SpringBootTestAnnotation other = (SpringBootTestAnnotation)obj;
        boolean result = Arrays.equals(this.args, other.args);
        result = result && this.useMainMethod == other.useMainMethod;
        result = result && this.webEnvironment == other.webEnvironment;
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.args);
        result = 31 * result + Objects.hash(new Object[]{this.useMainMethod, this.webEnvironment});
        return result;
    }

    String[] getArgs() {
        return this.args;
    }

    SpringBootTest.WebEnvironment getWebEnvironment() {
        return this.webEnvironment;
    }

    SpringBootTest.UseMainMethod getUseMainMethod() {
        return this.useMainMethod;
    }

    static SpringBootTestAnnotation get(MergedContextConfiguration mergedConfig) {
        for (ContextCustomizer customizer2 : mergedConfig.getContextCustomizers()) {
            if (!(customizer2 instanceof SpringBootTestAnnotation)) continue;
            SpringBootTestAnnotation annotation = (SpringBootTestAnnotation)customizer2;
            return annotation;
        }
        return DEFAULT;
    }
}

