/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.ssl;

import java.security.KeyStore;
import java.security.KeyStoreException;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public interface SslBundleKey {
    public static final SslBundleKey NONE = SslBundleKey.of(null, null);

    public String getPassword();

    public String getAlias();

    default public void assertContainsAlias(KeyStore keyStore) {
        String alias = this.getAlias();
        if (StringUtils.hasLength(alias) && keyStore != null) {
            try {
                Assert.state(keyStore.containsAlias(alias), () -> String.format("Keystore does not contain alias '%s'", alias));
            }
            catch (KeyStoreException ex) {
                throw new IllegalStateException(String.format("Could not determine if keystore contains alias '%s'", alias), ex);
            }
        }
    }

    public static SslBundleKey of(String password) {
        return SslBundleKey.of(password, null);
    }

    public static SslBundleKey of(final String password, final String alias) {
        return new SslBundleKey(){

            @Override
            public String getPassword() {
                return password;
            }

            @Override
            public String getAlias() {
                return alias;
            }

            public String toString() {
                ToStringCreator creator = new ToStringCreator(this);
                creator.append("alias", alias);
                creator.append("password", password != null ? "******" : null);
                return creator.toString();
            }
        };
    }
}

