/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.io;

import org.springframework.core.io.ContextResource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.ProtocolResolver;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.SpringFactoriesLoader;

public class ApplicationResourceLoader
extends DefaultResourceLoader {
    public ApplicationResourceLoader() {
        this(null);
    }

    public ApplicationResourceLoader(ClassLoader classLoader) {
        super(classLoader);
        SpringFactoriesLoader loader = SpringFactoriesLoader.forDefaultResourceLocation(classLoader);
        this.getProtocolResolvers().addAll(loader.load(ProtocolResolver.class));
    }

    @Override
    protected Resource getResourceByPath(String path) {
        return new FileSystemContextResource(path);
    }

    private static class FileSystemContextResource
    extends FileSystemResource
    implements ContextResource {
        FileSystemContextResource(String path) {
            super(path);
        }

        @Override
        public String getPathWithinContext() {
            return this.getPath();
        }
    }
}

